/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.agent.AgentEventListener;
import org.drools.agent.FileScanner;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;

public class DirectoryScanner
extends PackageProvider {
    private FileScanner scanner;
    private File dir;

    void configure(Properties config) {
        String d = config.getProperty("dir");
        this.dir = new File(d);
        if (!this.dir.isDirectory() || !this.dir.exists()) {
            throw new IllegalArgumentException("The directory " + d + "is not valid.");
        }
        this.scanner = new FileScanner();
        this.scanner.setFiles(this.dir.listFiles());
        this.scanner.setAgentListener(this.listener);
    }

    PackageChangeInfo loadPackageChanges() {
        Map<String, String> pathToPackage = this.scanner.pathToPackage;
        ArrayList<String> removedPackageNames = new ArrayList<String>();
        if (pathToPackage != null) {
            HashMap<String, String> tempPathToPackage = new HashMap<String, String>();
            File[] files = this.dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String path = f.getPath();
                if (!pathToPackage.containsKey(path)) continue;
                tempPathToPackage.put(path, pathToPackage.get(path));
                pathToPackage.remove(path);
            }
            if (pathToPackage.size() > 0 || files.length != tempPathToPackage.size()) {
                removedPackageNames.addAll(pathToPackage.values());
                this.listener.info("File changes detected in the directory " + this.dir.getPath());
                this.scanner.setFiles(files);
            }
            this.scanner.pathToPackage = tempPathToPackage;
        }
        PackageChangeInfo info = this.scanner.loadPackageChanges();
        info.addRemovedPackages(removedPackageNames);
        return info;
    }

    public void setAgentListener(AgentEventListener listener) {
        super.setAgentListener(listener);
        if (this.scanner != null) {
            this.scanner.setAgentListener(listener);
        }
    }

    public String toString() {
        String s = "DirectoryScanner";
        if (this.dir != null) {
            s = s + " scanning dir: " + this.dir.getPath();
        }
        if (this.scanner != null && this.scanner.files != null) {
            s = s + " found " + this.scanner.files.length + " file(s).";
        }
        return s;
    }
}

