/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.audit.event.LogEvent;

public class RuleFlowLogEvent
extends LogEvent {
    private String processId;
    private String processName;
    private long processInstanceId;

    public RuleFlowLogEvent(int type, String processId, String processName, long processInstanceId) {
        super(type);
        this.processId = processId;
        this.processName = processName;
        this.processInstanceId = processInstanceId;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.processId = (String)in.readObject();
        this.processName = (String)in.readObject();
        this.processInstanceId = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.processId);
        out.writeObject(this.processName);
        out.writeLong(this.processInstanceId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 8: {
                msg = "BEFORE RULEFLOW STARTED";
                break;
            }
            case 9: {
                msg = "AFTER RULEFLOW STARTED";
                break;
            }
            case 10: {
                msg = "BEFORE RULEFLOW COMPLETED";
                break;
            }
            case 11: {
                msg = "AFTER RULEFLOW COMPLETED";
            }
        }
        return msg + " process:" + this.processName + "[id=" + this.processId + "]";
    }
}

