/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.core.util.StringUtils;

public class ReaderInputStream
extends InputStream {
    private Reader in;
    private String encoding = System.getProperty("file.encoding");
    private byte[] slack;
    private int begin;

    public ReaderInputStream(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.in = reader;
        if (reader instanceof InputStreamReader && !StringUtils.isEmpty(((InputStreamReader)reader).getEncoding())) {
            this.encoding = ((InputStreamReader)reader).getEncoding();
        }
    }

    public ReaderInputStream(Reader reader, String encoding) {
        this(reader);
        if (encoding == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        this.encoding = encoding;
    }

    public synchronized int read() throws IOException {
        byte result;
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null && this.begin < this.slack.length) {
            result = this.slack[this.begin];
            if (++this.begin == this.slack.length) {
                this.slack = null;
            }
        } else {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) <= 0) {
                return -1;
            }
            result = buf[0];
        }
        return result & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (len == 0) {
            return 0;
        }
        while (this.slack == null) {
            char[] buf = new char[len];
            int n = this.in.read(buf);
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            this.slack = new String(buf, 0, n).getBytes(this.encoding);
            this.begin = 0;
        }
        if (len > this.slack.length - this.begin) {
            len = this.slack.length - this.begin;
        }
        System.arraycopy(this.slack, this.begin, b, off, len);
        if ((this.begin += len) >= this.slack.length) {
            this.slack = null;
        }
        return len;
    }

    public synchronized void mark(int limit) {
        try {
            this.in.mark(limit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public synchronized int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null) {
            return this.slack.length - this.begin;
        }
        if (this.in.ready()) {
            return 1;
        }
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        this.slack = null;
        this.in.reset();
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.slack = null;
            this.in = null;
        }
    }
}

