/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.dataproviders.MVELDataProvider;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.From;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;

public class MVELFromBuilder
implements FromBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, (Pattern)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        boolean typeSafe = context.isTypesafe();
        if (!dialect.isStrictMode()) {
            context.setTypesafe(false);
        }
        FromDescr fromDescr = (FromDescr)descr;
        MVELExprDescr expr = (MVELExprDescr)fromDescr.getDataSource();
        From from = null;
        try {
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            String text = expr.getText();
            AnalysisResult analysis = dialect.analyzeExpression(context, descr, text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getKnowledgeBuilder().getGlobals()));
            if (analysis == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            Class returnType = ((MVELAnalysisResult)analysis).getReturnType();
            if (prefixPattern != null && !prefixPattern.isCompatibleWithFromReturnType(returnType)) {
                context.addError(new DescrBuildError(descr, context.getRuleDescr(), null, "Pattern of type: '" + prefixPattern.getObjectType() + "' on rule '" + context.getRuleDescr().getName() + "' is not compatible with type " + returnType.getCanonicalName() + " returned by source"));
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            int j = 0;
            for (String str : usedIdentifiers.getDeclrClasses().keySet()) {
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, declarations, null, null, context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.CONSEQUENCE);
            MVELDataProvider dataProvider = new MVELDataProvider(unit, context.getDialect().getId());
            from = new From((DataProvider)dataProvider);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)from, (MVELCompileable)dataProvider);
            dataProvider.compile(data, context.getRule());
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, fromDescr);
            context.addError(new DescrBuildError(context.getParentDescr(), fromDescr, null, "Unable to build expression for 'from' : " + e.getMessage() + " '" + expr.getText() + "'"));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
        from.setResultPattern(prefixPattern);
        return from;
    }
}

