/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.Trigger;
import org.drools.core.util.LinkedList;
import org.kie.api.runtime.rule.Agenda;

public final class Scheduler {
    private Scheduler() {
    }

    public static class ActivationTimerInputMarshaller
    implements TimersInputMarshaller {
        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            ProtobufMessages.Timers.ActivationTimer _activation = _timer.getActivation();
            Tuple leftTuple = inCtx.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_activation.getActivation().getPackageName(), _activation.getActivation().getRuleName(), _activation.getActivation().getTuple()));
            if (leftTuple == null) {
                return;
            }
            ScheduledAgendaItem item = (ScheduledAgendaItem)leftTuple.getContextObject();
            Trigger trigger = ProtobufInputMarshaller.readTrigger(inCtx, _activation.getTrigger());
            ActivationTimerJobContext ctx = new ActivationTimerJobContext(trigger, item, inCtx.wm.getAgenda());
            JobHandle jobHandle = inCtx.wm.getTimerService().scheduleJob(new ActivationTimerJob(), ctx, trigger);
            item.setJobHandle(jobHandle);
        }
    }

    public static class ActivationTimerOutputMarshaller
    implements TimersOutputMarshaller {
        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            ActivationTimerJobContext ajobCtx = (ActivationTimerJobContext)jobCtx;
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.ACTIVATION).setActivation(ProtobufMessages.Timers.ActivationTimer.newBuilder().setActivation(PersisterHelper.createActivation(ajobCtx.getScheduledAgendaItem().getRule().getPackageName(), ajobCtx.getScheduledAgendaItem().getRule().getName(), ajobCtx.getScheduledAgendaItem().getTuple())).setTrigger(ProtobufOutputMarshaller.writeTrigger(ajobCtx.getTrigger(), outputCtx)).build()).build();
        }
    }

    public static class ActivationTimerJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private ScheduledAgendaItem scheduledAgendaItem;
        private Agenda agenda;
        private Trigger trigger;

        public ActivationTimerJobContext(Trigger trigger, ScheduledAgendaItem scheduledAgendaItem, Agenda agenda) {
            this.trigger = trigger;
            this.scheduledAgendaItem = scheduledAgendaItem;
            this.agenda = agenda;
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public ScheduledAgendaItem getScheduledAgendaItem() {
            return this.scheduledAgendaItem;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public void setScheduledAgendaItem(ScheduledAgendaItem scheduledAgendaItem) {
            this.scheduledAgendaItem = scheduledAgendaItem;
        }

        public void setAgenda(Agenda agenda) {
            this.agenda = agenda;
        }

        public void setTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        @Override
        public InternalWorkingMemory getWorkingMemory() {
            return ((InternalAgenda)this.agenda).getWorkingMemory();
        }
    }

    public static class ActivationTimerJob<T extends ModedAssertion<T>>
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            InternalAgenda agenda = (InternalAgenda)((ActivationTimerJobContext)ctx).getAgenda();
            ScheduledAgendaItem item = ((ActivationTimerJobContext)ctx).getScheduledAgendaItem();
            boolean wasFired = agenda.fireTimedActivation(item);
            if (((ActivationTimerJobContext)ctx).getTrigger().hasNextFireTime() == null) {
                if (wasFired) {
                    agenda.getWorkingMemory().fireAllRules();
                } else {
                    this.postpone(item, agenda);
                }
                if (item.isEnqueued()) {
                    LinkedList<ScheduledAgendaItem<ScheduledAgendaItem>> schedules = agenda.getScheduledActivationsLinkedList();
                    schedules.remove(item);
                    item.setEnqueued(false);
                }
            } else {
                item.setQueued(true);
                if (wasFired) {
                    agenda.getWorkingMemory().fireAllRules();
                } else {
                    this.postpone(item, agenda);
                }
            }
        }

        private void postpone(ScheduledAgendaItem item, InternalAgenda agenda) {
            LeftTuple lt;
            LeftTuple postponedTuple = item.getTuple().getParent() != null ? ((lt = (LeftTuple)item.getTuple()).getRightParent() != null ? item.getTerminalNode().createLeftTuple(lt.getLeftParent(), lt.getRightParent(), null, null, (Sink)item.getTuple().getTupleSink(), true) : item.getTerminalNode().createLeftTuple(lt.getParent(), (Sink)item.getTuple().getTupleSink(), item.getTuple().getPropagationContext(), true)) : item.getTerminalNode().createLeftTuple(item.getTuple().getFactHandle(), (Sink)item.getTuple().getTupleSink(), true);
            agenda.createPostponedActivation(postponedTuple, item.getPropagationContext(), agenda.getWorkingMemory(), item.getTerminalNode());
            agenda.addActivation((AgendaItem)postponedTuple.getContextObject());
        }
    }
}

