% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nmean.rec.R
\name{Nmean.rec}
\alias{Nmean.rec}
\title{Mean number of records}
\usage{
Nmean.rec(XM_T, record = "upper")
}
\arguments{
\item{XM_T}{A numeric vector or  matrix.}

\item{record}{A character string indicating the type of record  to be calculated, "upper" or "lower".}
}
\value{
A numeric vector   or matrix (depending on the input \code{XM_T})  with the mean  number of records up to  each time (row).
}
\description{
This function calculates the mean  number of records up to time \eqn{t} in a vector.
}
\details{
If the argument \code{XM_T} is a matrix,  the approach to obtain  the mean number of records is applied to each
column of the matrix, and the return value is  a matrix  formed by the corresponding vectors.
}
\examples{
Y1<-c(1,5,3,6,6,9,2)
Y2<-c(10,5,3,6,6,9,2)
Y3<-c(5,7,3,6,19,2,20)
Nmean.rec(Y1)
Nmean.rec(cbind(Y1,Y2,Y3))
}
\seealso{
\code{\link{N.rec}}, \code{\link{L.rec}}, \code{\link{I.rec}}
}
