% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double.fun.R
\name{double.fun}
\alias{double.fun}
\title{Transforms a \eqn{T \times M}  in a \eqn{[T/2] \times 2M} matrix}
\usage{
double.fun(mm)
}
\arguments{
\item{mm}{A numeric  matrix.}
}
\value{
A  \eqn{[T/2] \times 2M} matrix.
}
\description{
It  changes the format of a matrix, in  the following way.
 First, the matrix is divided into two matrices \eqn{[T/2] \times M} ,  containing the odd  and the even rows of the original matrix, respectively,
 and secondly those matrices are cbinded.
}
\details{
This function is used in the data preparation  (or pre-processing) often
required to apply the record inference tools in this package.

 Most of the  record inference tools   require a high   number of independent series \eqn{M} (number of columns) to be applied.
 If \eqn{M} is low and the time period of observation, \eqn{T},  is  high enough,  the following procedure can be applied in order to double  the value \eqn{M}.
The approach  consists of  considering that the observations at two consesutive times, \eqn{t} and \eqn{t+1}, are independent observations   measured at the same time unit.
That means that we are doubling the original  time unit of the records, so that the length of the observation period  will be \eqn{[T/2]}.
This function rearranges  the original  data matrix  into the  new format.

If  the  number of rows of the original matrix is even,  the first row  is deleted.
}
\examples{
double.fun(matrix(1:100,10,10))
}
\seealso{
\code{\link{DaySeries.fun}}, \code{\link{mintime.cor.test}}
}
