% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rga.R
\name{plot_rga}
\alias{plot_rga}
\title{Plotting Function for Reliability Growth Analysis}
\usage{
plot_rga(
  rga_obj,
  point_col = "black",
  line_col = "black",
  xlab = "Cumulative Time",
  ylab = "Cumulative Failures",
  main = "Reliability Growth Analysis"
)
}
\arguments{
\item{rga_obj}{An object of class \code{rga}, which contains the results from the RGA model.}

\item{point_col}{Color for the data points (default: "black").}

\item{line_col}{Color for the fitted line (default: "black").}

\item{xlab}{Label for the x-axis (default: "Cumulative Time").}

\item{ylab}{Label for the y-axis (default: "Cumulative Failures").}

\item{main}{Title for the plot (default: "Reliability Growth Analysis").}
}
\value{
The function does not return a value.
}
\description{
Plotting Function for Reliability Growth Analysis
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
result <- rga(times, failures)
plot_rga(result)
}
