% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hldepth.R
\name{hldepth}
\alias{hldepth}
\title{Calculates the halfspace location depth}
\usage{
hldepth(D, G, verbose = TRUE)
}
\arguments{
\item{D}{Data set with rows representing the individuals and
columns representing the features. In the case of three
dimensions, the colnames of D must be c("x", "y", "z").}

\item{G}{List containing the grid information produced by
\code{\link{gridfun}}.}

\item{verbose}{Logical. Indicates whether progress information is
printed during calculation.}
}
\value{
\describe{
\item{\emph{H}}{An array of the same dimension as the array in argument G. The elements contain the halfspace location depth at the related grid location.}
}
}
\description{
Calculates the halfspace location depth for each point in a given grid.
}
\details{
Calculation of the halfspace location depth at each grid point is
mandatory before calculating the depth median
(\code{\link{depmed}}), the bag (\code{\link{bag}}) and the loop
(\code{\link{loop}}). Ideally, the output is assigned to the array
H produced by \code{\link{gridfun}}.
}
\examples{
## Attention: calculation is currently time-consuming.
## Remove #-Symbols to run examples

## A 3-dimensional example data set D1
# n <- 200
# x1 <- rnorm(n, 0, 1)
# y1 <- rnorm(n, 0, 1)
# z1 <- rnorm(n, 0, 1)
# D1 <- data.frame(cbind(x1, y1, z1))
# colnames(D1) <- c("x", "y", "z")

## Specification of the grid and calculation of the halfspace location depth at each grid location.
# G <- gridfun(D1, grid.size=20)
# G$H <- hldepth(D1, G, verbose=TRUE)
}
\references{
Rousseeuw, P. J., Ruts, I., & Tukey, J. W. (1999). The
    bagplot: a bivariate boxplot. The American Statistician,
    53(4), 382-387.
}
\author{
Jochen Kruppa, Klaus Jung
}
