/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.dml.CTTransform2D;
import org.lysis.reporters.pptx4r.elements.template.MasterLayoutProperties;
import org.lysis.reporters.pptx4r.elements.template.ShapeDescription;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.Shape;

public class LayoutDescription {
    public static int TITLE = 0;
    public static int FOOTER = 1;
    public static int SLIDENUMBER = 2;
    public static int DATE = 3;
    public static int SUBTITLE = 4;
    public static int CRTTITLE = 5;
    public static int BODY = 6;
    private HashMap<Integer, ShapeDescription> listBodyShapeDescription = new HashMap();
    private HashMap<Integer, ShapeDescription> listHeaderShapeDescription = new HashMap();
    private String label;
    private String xmlFilename;
    private int max_content = 0;
    private boolean has_title = false;
    private boolean has_footer = false;
    private boolean has_slidenumber = false;
    private boolean has_date = false;
    private boolean has_subtitle = false;
    private boolean has_crttitle = false;
    private long idx_title;
    private long idx_footer;
    private long idx_slidenumber;
    private long idx_date;
    private long idx_subtitle;
    private long idx_crttitle;

    public LayoutDescription(List<Object> slidesSet) {
        for (Object element : slidesSet) {
            if (!element.getClass().equals(Shape.class)) continue;
            Shape s = (Shape)element;
            ShapeDescription sd = new ShapeDescription(s);
            if (sd.getShapeType().equals("title")) {
                this.has_title = true;
                this.idx_title = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.TITLE, sd);
                continue;
            }
            if (sd.getShapeType().equals("dt")) {
                this.has_date = true;
                this.idx_date = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.DATE, sd);
                continue;
            }
            if (sd.getShapeType().equals("ftr")) {
                this.has_footer = true;
                this.idx_footer = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.FOOTER, sd);
                continue;
            }
            if (sd.getShapeType().equals("sldNum")) {
                this.has_slidenumber = true;
                this.idx_slidenumber = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.SLIDENUMBER, sd);
                continue;
            }
            if (sd.getShapeType().equals("subTitle")) {
                this.has_subtitle = true;
                this.idx_subtitle = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.SUBTITLE, sd);
                continue;
            }
            if (sd.getShapeType().equals("ctrTitle")) {
                this.has_crttitle = true;
                this.idx_crttitle = sd.getIdx();
                this.listHeaderShapeDescription.put(MasterLayoutProperties.CRTTITLE, sd);
                continue;
            }
            if (!sd.getShapeType().equals("body") && !sd.getShapeType().equals("tbl") && !sd.getShapeType().equals("obj") && !sd.getShapeType().equals("pic")) continue;
            this.listBodyShapeDescription.put(this.max_content, sd);
            ++this.max_content;
            if (!Debug.doc_explorer) continue;
            System.err.println("\t* shape (has xfrm : " + sd.hasXfrm() + ") of type: " + sd.getShapeType());
        }
    }

    public void fixMissingXfrm(MasterLayoutProperties masterLayout) {
        if (this.hasTitle() && !this.listHeaderShapeDescription.get(TITLE).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasTitle and no xfrm");
            }
            this.listHeaderShapeDescription.get(TITLE).setXfrm(masterLayout.getShapeDescription(TITLE).getXfrm());
        }
        if (this.hasSubtitle() && !this.listHeaderShapeDescription.get(SUBTITLE).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasSubTitle and no xfrm");
            }
            this.listHeaderShapeDescription.get(SUBTITLE).setXfrm(masterLayout.getShapeDescription(SUBTITLE).getXfrm());
        }
        if (this.hasFooter() && !this.listHeaderShapeDescription.get(FOOTER).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasFooter and no xfrm");
            }
            this.listHeaderShapeDescription.get(FOOTER).setXfrm(masterLayout.getShapeDescription(FOOTER).getXfrm());
        }
        if (this.hasSlideNumber() && !this.listHeaderShapeDescription.get(SLIDENUMBER).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasSlideNumber and no xfrm");
            }
            this.listHeaderShapeDescription.get(SLIDENUMBER).setXfrm(masterLayout.getShapeDescription(SLIDENUMBER).getXfrm());
        }
        if (this.hasDate() && !this.listHeaderShapeDescription.get(DATE).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasDate and no xfrm");
            }
            this.listHeaderShapeDescription.get(DATE).setXfrm(masterLayout.getShapeDescription(DATE).getXfrm());
        }
        if (this.hasCrttitle() && !this.listHeaderShapeDescription.get(CRTTITLE).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: hasCrtTitle and no xfrm");
            }
            this.listHeaderShapeDescription.get(CRTTITLE).setXfrm(masterLayout.getShapeDescription(CRTTITLE).getXfrm());
        }
        if (this.max_content == 1 && !this.listBodyShapeDescription.get(0).hasXfrm()) {
            if (Debug.doc_explorer) {
                System.err.println("fixMissingXfrm: 1 body and no xfrm");
            }
            this.listBodyShapeDescription.get(0).setXfrm(masterLayout.getShapeDescription(BODY).getXfrm());
        }
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    public void setXMLFilename(String _key) {
        this.xmlFilename = _key;
    }

    public ShapeDescription getContent(int id) {
        return this.listBodyShapeDescription.get(id);
    }

    public int[] getHeaderDimensions() {
        int num_headers = this.getNumberOfHeaders();
        int[] data = new int[5 * num_headers];
        int index = 0;
        for (Map.Entry<Integer, ShapeDescription> en : this.listHeaderShapeDescription.entrySet()) {
            int[] temp = this.getHeaderDimensions(en.getKey());
            data[index] = en.getKey();
            data[++index] = temp[0];
            data[++index] = temp[1];
            data[++index] = temp[2];
            data[++index] = temp[3];
            ++index;
        }
        return data;
    }

    public int[] getHeaderDimensions(int i) {
        int[] data = new int[4];
        if (i == TITLE && !this.hasTitle()) {
            return data;
        }
        if (i == FOOTER && !this.hasFooter()) {
            return data;
        }
        if (i == SLIDENUMBER && !this.hasSlideNumber()) {
            return data;
        }
        if (i == DATE && !this.hasDate()) {
            return data;
        }
        if (i == SUBTITLE && !this.hasSubtitle()) {
            return data;
        }
        if (i == CRTTITLE && !this.hasCrttitle()) {
            return data;
        }
        CTTransform2D xfrm = this.listHeaderShapeDescription.get(i).getXfrm();
        Long offx = new Long(xfrm.getOff().getX());
        Long offy = new Long(xfrm.getOff().getY());
        Long extx = new Long(xfrm.getExt().getCx());
        Long exty = new Long(xfrm.getExt().getCy());
        data[0] = offx.intValue();
        data[1] = offy.intValue();
        data[2] = extx.intValue();
        data[3] = exty.intValue();
        return data;
    }

    public int[] getContentDimensions() {
        int[] data = new int[4 * this.max_content];
        int index = 0;
        int id = 0;
        while (id < this.max_content) {
            CTTransform2D xfrm = this.listBodyShapeDescription.get(id).getXfrm();
            Long offx = new Long(xfrm.getOff().getX());
            Long offy = new Long(xfrm.getOff().getY());
            Long extx = new Long(xfrm.getExt().getCx());
            Long exty = new Long(xfrm.getExt().getCy());
            data[index] = offx.intValue();
            data[++index] = offy.intValue();
            data[++index] = extx.intValue();
            data[++index] = exty.intValue();
            ++index;
            ++id;
        }
        return data;
    }

    public int[] getContentDimensions(int id) {
        int[] data = new int[4];
        CTTransform2D xfrm = this.listBodyShapeDescription.get(id).getXfrm();
        Long offx = new Long(xfrm.getOff().getX());
        Long offy = new Long(xfrm.getOff().getY());
        Long extx = new Long(xfrm.getExt().getCx());
        Long exty = new Long(xfrm.getExt().getCy());
        data[0] = offx.intValue();
        data[1] = offy.intValue();
        data[2] = extx.intValue();
        data[3] = exty.intValue();
        return data;
    }

    public String getLabel() {
        return this.label;
    }

    public String getXMLFilename() {
        return this.xmlFilename;
    }

    public HashMap<Integer, Boolean> getIsFilledHeaderModel() {
        HashMap<Integer, Boolean> out = new HashMap<Integer, Boolean>();
        if (this.hasTitle()) {
            out.put(MasterLayoutProperties.TITLE, false);
        }
        if (this.hasDate()) {
            out.put(MasterLayoutProperties.DATE, false);
        }
        if (this.hasFooter()) {
            out.put(MasterLayoutProperties.FOOTER, false);
        }
        if (this.hasSlideNumber()) {
            out.put(MasterLayoutProperties.SLIDENUMBER, false);
        }
        if (this.hasCrttitle()) {
            out.put(MasterLayoutProperties.CRTTITLE, false);
        }
        if (this.hasSubtitle()) {
            out.put(MasterLayoutProperties.SUBTITLE, false);
        }
        return out;
    }

    public int getContentSize() {
        return this.max_content;
    }

    public boolean hasTitle() {
        return this.has_title;
    }

    public boolean hasFooter() {
        return this.has_footer;
    }

    public boolean hasSlideNumber() {
        return this.has_slidenumber;
    }

    public boolean hasDate() {
        return this.has_date;
    }

    public boolean hasSubtitle() {
        return this.has_subtitle;
    }

    public boolean hasCrttitle() {
        return this.has_crttitle;
    }

    private int getNumberOfHeaders() {
        int num_headers = 0;
        if (this.hasTitle()) {
            ++num_headers;
        }
        if (this.hasDate()) {
            ++num_headers;
        }
        if (this.hasFooter()) {
            ++num_headers;
        }
        if (this.hasSlideNumber()) {
            ++num_headers;
        }
        if (this.hasCrttitle()) {
            ++num_headers;
        }
        if (this.hasSubtitle()) {
            ++num_headers;
        }
        return num_headers;
    }

    public long getIdx_title() {
        return this.idx_title;
    }

    public long getIdx_footer() {
        return this.idx_footer;
    }

    public long getIdx_slidenumber() {
        return this.idx_slidenumber;
    }

    public long getIdx_date() {
        return this.idx_date;
    }

    public long getIdx_subtitle() {
        return this.idx_subtitle;
    }

    public long getIdx_crttitle() {
        return this.idx_crttitle;
    }
}

