% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addImage.R
\name{addImage}
\alias{addImage}
\alias{addImage.docx}
\alias{addImage.pptx}
\title{Add an external image into a document object}
\usage{
addImage(doc, filename, ...)

\method{addImage}{docx}(doc, filename, bookmark,
  par.properties = parProperties(text.align = "center", padding = 5), width,
  height, ...)

\method{addImage}{pptx}(doc, filename, offx, offy, width, height, ...)
}
\arguments{
\item{doc}{document object}

\item{filename}{\code{"character"} value, complete filename
of the external image}

\item{...}{further arguments passed to other methods}

\item{bookmark}{a character value ; id of the Word bookmark to replace by the image.
optional. if missing, image is added at the end of the document.}

\item{par.properties}{paragraph formatting properties of the paragraph that contains images.
An object of class \code{\link{parProperties}}. It has no effect if doc is
a \code{pptx} object.}

\item{width}{image width in inches}

\item{height}{image height in inches}

\item{offx}{optional, x position of the shape (top left position of the bounding box) in inches. See details.}

\item{offy}{optional, y position of the shape (top left position of the bounding box) in inches See details.}
}
\value{
a document object
}
\description{
Add an external image into a document object
}
\details{
Arguments \code{width} and \code{height} can be defined with functions
\code{png::readPNG}, \code{jpeg::readJPEG} or \code{bmp::read.bmp}.

When document object is a \code{pptx}, width and height are not mandatory.
By default, image is added to the next free 'content' shape of the current slide.
See \code{\link{slide.layouts.pptx}} to view the slide layout.

If arguments offx and offy are missing, position is defined as
the position of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.
}
\examples{

# get rlogo
img.file <- file.path( Sys.getenv("R_HOME"), "doc", "html", "logo.jpg" )

# tests to use later
has_img <- file.exists( img.file )
has_jpeg <- requireNamespace("jpeg", quietly = TRUE)
has_wmf <- exists("win.metafile")
is_sunos <- tolower(Sys.info()[["sysname"]]) == "sunos"

# create a wmf file if possible
if( has_wmf ){
  win.metafile(filename = "image.wmf", width = 5, height = 5 )
  barplot( 1:6, col = 2:7)
  dev.off()
}


# Image example for MS Word -------
\donttest{
doc <- docx()

if( has_img && has_jpeg ){
  dims <- attr( jpeg::readJPEG(img.file), "dim" )
  doc <- addImage(doc, img.file, width = dims[2]/72,
    height = dims[1]/72)
}

if( has_wmf ){
  doc <- addImage(doc, "image.wmf", width = 5, height = 5 )
}

writeDoc( doc, file = "ex_add_image.docx" )
}

# Image example for MS PowerPoint -------
\donttest{
if( !is_sunos ){

doc <- pptx()

if( has_img && has_jpeg ){
  doc <- addSlide( doc, "Title and Content" )
  dims <- attr( jpeg::readJPEG(img.file), "dim" )
  doc <- addImage(doc, img.file, width = dims[2]/72,
    height = dims[1]/72)
}
if( has_wmf ){
  doc <- addSlide( doc, "Title and Content" )
  doc <- addImage(doc, "image.wmf", width = 5, height = 5 )
}

writeDoc( doc, file = "ex_add_image.pptx" )
}
}

}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}
}
