% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTablePublicAPI.R
\name{setFlexTableBorders}
\alias{setFlexTableBorders}
\title{change grid lines of a FlexTable}
\usage{
setFlexTableBorders(object, inner.vertical = borderProperties(),
  inner.horizontal = borderProperties(),
  outer.vertical = borderProperties(),
  outer.horizontal = borderProperties(), body = TRUE, header = TRUE,
  footer = FALSE)
}
\arguments{
\item{object}{a \code{FlexTable} object}

\item{inner.vertical}{a \code{\link{borderProperties}} object}

\item{inner.horizontal}{a \code{\link{borderProperties}} object}

\item{outer.vertical}{a \code{\link{borderProperties}} object}

\item{outer.horizontal}{a \code{\link{borderProperties}} object}

\item{body}{a logical value (default to TRUE), specifies
to apply scheme to table body}

\item{header}{a logical value (default to TRUE), specifies
to apply scheme to table header}

\item{footer}{a logical value (default to FALSE), specifies
to apply scheme to table footer}
}
\description{
apply borders scheme to a FlexTable. A border scheme is
a set of 4 different borders: inner vectical and horizontal
, outer vectical and horizontal.
}
\examples{
#
# Create a FlexTable object with first 10 lines of data.frame mtcars
# add row.names as first column
MyFTable = FlexTable( data = mtcars[1:10, ]
  , add.rownames=TRUE
)
MyFTable = setFlexTableBorders( MyFTable, 
  inner.vertical = borderProperties( style = "dashed" ), 
  inner.horizontal = borderProperties( style = "dashed" ), 
  outer.vertical = borderProperties( width = 2 ), 
  outer.horizontal = borderProperties( width = 2 ) )
}
\seealso{
\code{\link{FlexTable}}
}

