/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriterUTF8;
import java.io.IOException;
import java.io.Writer;

abstract class XMLWriterBase
implements XMLWriter {
    final Writer writer;
    String encoding = "utf-8";
    XMLEscapeWriter writerEscape;
    int depth = 0;
    boolean indent;
    private String indentChars = null;
    boolean isNude = false;

    public XMLWriterBase(Writer writer, boolean indent) throws NullPointerException {
        if (writer == null) {
            throw new NullPointerException("XMLWriter cannot use a null writer.");
        }
        this.writer = writer;
        this.writerEscape = new XMLEscapeWriterUTF8(writer);
        this.indent = indent;
        if (indent) {
            this.indentChars = "  ";
        }
    }

    public final void xmlDecl() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public final void setIndentChars(String spaces) throws IllegalStateException, IllegalArgumentException {
        if (this.depth != 0) {
            throw new IllegalStateException("To late to set the indentation characters!");
        }
        if (spaces != null) {
            for (int i = 0; i < spaces.length(); ++i) {
                if (Character.isSpaceChar(spaces.charAt(i))) continue;
                throw new IllegalArgumentException("Not a valid indentation string.");
            }
        }
        this.indentChars = spaces;
        this.indent = spaces != null;
    }

    public final void setEncoding(String encoding) throws IllegalStateException, IllegalArgumentException {
        if (this.depth != 0) {
            throw new IllegalStateException("To late to set the encoding!");
        }
        this.encoding = encoding;
    }

    public final void writeText(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writerEscape.writeText(text);
    }

    public final void writeText(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writerEscape.writeText(text, off, len);
    }

    public final void writeText(char c) throws IOException {
        this.deNude();
        this.writerEscape.writeText(c);
    }

    public final void writeText(Object o) throws IOException {
        if (o != null) {
            this.writeText(o.toString());
        }
    }

    public final void writeXML(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writer.write(text);
    }

    public final void writeXML(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writer.write(text, off, len);
    }

    public final void writeComment(String comment) throws IOException, IllegalArgumentException {
        if (comment == null) {
            return;
        }
        if (comment.indexOf("--") >= 0) {
            throw new IllegalArgumentException("A comment must not contain '--'.");
        }
        this.deNude();
        this.writer.write("<!-- ");
        this.writer.write(comment);
        this.writer.write(" -->");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public final void writePI(String target, String data) throws IOException {
        this.deNude();
        this.writer.write("<?");
        this.writer.write(target);
        this.writer.write(32);
        this.writer.write(data);
        this.writer.write("?>");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public final void writeCDATA(String data) throws IOException {
        if (data == null) {
            return;
        }
        String end = "]]>";
        if (data.indexOf("]]>") >= 0) {
            throw new IllegalArgumentException("CDATA sections must not contain ']]>'");
        }
        this.deNude();
        this.writer.write("<![CDATA[");
        this.writer.write(data);
        this.writer.write("]]>");
    }

    public final void attribute(String name, String value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write(61);
        this.writer.write(34);
        this.writerEscape.writeAttValue(value);
        this.writer.write(34);
    }

    public final void attribute(String name, int value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write(61);
        this.writer.write(34);
        this.writer.write(Integer.toString(value));
        this.writer.write(34);
    }

    public void element(String name, String text) throws IOException {
        this.openElement(name);
        this.writeText(text);
        this.closeElement();
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    abstract void deNude() throws IOException;

    void indent() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write(this.indentChars);
            }
        }
    }

    static final void doNothing() {
    }
}

