/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.docx4j.XmlUtils;
import org.docx4j.fonts.CJKToEnglish;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class RunFontSelector {
    protected static Logger log = LoggerFactory.getLogger(RunFontSelector.class);
    private WordprocessingMLPackage wordMLPackage;
    private RunFontCharacterVisitor vis;
    private RunFontActionType outputType;
    String fallbackFont = null;
    CTLanguage themeFontLang = null;
    public static final String CSS_NAME = "font-family";
    public static final String FO_NAME = "font-family";
    private Style defaultParagraphStyle;
    private String defaultFont = null;
    private boolean spacePreserve;

    public RunFontSelector(WordprocessingMLPackage wordMLPackage, RunFontCharacterVisitor visitor, RunFontActionType outputType) {
        this.wordMLPackage = wordMLPackage;
        this.vis = visitor;
        this.outputType = outputType;
        this.vis.setRunFontSelector(this);
        this.fallbackFont = this.getPhysicalFont(this.getDefaultFont());
        if (this.fallbackFont == null) {
            this.fallbackFont = this.getDefaultFont();
            log.warn(this.getDefaultFont() + " is not mapped!");
        }
        this.vis.setFallbackFont(this.fallbackFont);
        if (wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null) {
            this.themeFontLang = ((CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getThemeFontLang();
        }
    }

    public String getCssName() {
        return "font-family";
    }

    private ThemePart getThemePart() {
        return this.wordMLPackage.getMainDocumentPart().getThemePart();
    }

    private Style getDefaultPStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null ? this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        }
        return this.defaultParagraphStyle;
    }

    public String getDefaultFont() {
        if (this.defaultFont == null) {
            PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
            RFonts rFonts = propertyResolver.getDocumentDefaultRPr().getRFonts();
            if (rFonts == null) {
                log.info("No styles/docDefaults/rPrDefault/rPr/rFonts - default to Times New Roman");
                this.defaultFont = "Times New Roman";
            } else if (rFonts.getAsciiTheme() == null) {
                if (rFonts.getAscii() == null) {
                    log.error("Neither ascii or asciTheme.  What to do? ");
                    this.defaultFont = "Times New Roman";
                } else {
                    log.info("rPrDefault/rFonts referenced " + rFonts.getAscii());
                    this.defaultFont = rFonts.getAscii();
                }
            } else if (this.getThemePart() == null) {
                log.info("No theme part - default to Calibri");
                this.defaultFont = "Calibri";
            } else {
                String font = this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang);
                if (font != null) {
                    this.defaultFont = font;
                } else {
                    log.info("No minorFont/latin in theme part - default to Calibri");
                    this.defaultFont = "Calibri";
                }
            }
        }
        return this.defaultFont;
    }

    private DocumentFragment nullRPr(Document document, String text) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            this.vis.fontAction(this.getDefaultFont());
            return null;
        }
        Element span = this.createElement(document);
        if (span != null) {
            document.appendChild(span);
            this.setAttribute(span, this.getDefaultFont());
            span.setTextContent(text);
        }
        return this.result(document);
    }

    private DocumentFragment result(Document document) {
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    public Element createElement(Document document) {
        Element el = null;
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return null;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            el = document.createElement("span");
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            el = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
        }
        return el;
    }

    public void setAttribute(Element el, String fontName) {
        if (this.outputType == RunFontActionType.XHTML) {
            if (this.spacePreserve) {
                el.setAttribute("style", this.getCssProperty(fontName) + "white-space:pre-wrap;");
            } else {
                el.setAttribute("style", this.getCssProperty(fontName));
            }
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            String val = this.getPhysicalFont(fontName);
            if (val == null) {
                el.setAttribute("font-family", this.fallbackFont);
            } else {
                el.setAttribute("font-family", this.getPhysicalFont(fontName));
            }
        }
    }

    public Object fontSelector(PPr pPr, RPr rPr, Text wmlText) {
        String text = wmlText.getValue();
        this.spacePreserve = wmlText.getSpace() != null && wmlText.getSpace().equals("preserve");
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        Style pStyle = null;
        RPr pRPr = null;
        if (pPr == null || pPr.getPStyle() == null) {
            pStyle = this.getDefaultPStyle();
            log.debug("using default p style");
            pRPr = pStyle.getRPr();
        } else if (this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null) {
            log.debug(pPr.getPStyle().getVal());
            pRPr = propertyResolver.getEffectiveRPr(pPr.getPStyle().getVal());
        }
        rPr = propertyResolver.getEffectiveRPrUsingPStyleRPr(rPr, pRPr);
        log.debug("effective\n" + XmlUtils.marshaltoString((Object)rPr, true, true));
        Document document = this.getDocument();
        if (rPr == null) {
            log.warn("effective rPr is null");
            return this.nullRPr(document, text);
        }
        RFonts rFonts = rPr.getRFonts();
        if (rFonts == null) {
            return this.nullRPr(document, text);
        }
        if (rPr.getCs() != null || rPr.getRtl() != null) {
            if (rFonts.getCstheme() != null) {
                Element span;
                String fontName = null;
                if (this.getThemePart() != null) {
                    fontName = this.getThemePart().getFont(rFonts.getCstheme(), this.themeFontLang);
                }
                if (fontName == null) {
                    fontName = rFonts.getCs();
                }
                if (fontName == null) {
                    // empty if block
                }
                if ((span = this.createElement(document)) != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
            if (rFonts.getCs() != null) {
                String fontName = rFonts.getCs();
                Element span = this.createElement(document);
                if (span != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
        }
        String eastAsia = null;
        String ascii = null;
        String hAnsi = null;
        STHint hint = rFonts.getHint();
        if (rFonts.getEastAsiaTheme() != null && this.getThemePart() != null) {
            eastAsia = this.getThemePart().getFont(rFonts.getEastAsiaTheme(), this.themeFontLang);
            if (eastAsia == null) {
                log.info("theme font for lang " + this.themeFontLang + " is " + eastAsia + ", but we don't have that");
                eastAsia = rFonts.getEastAsia();
            }
        } else {
            eastAsia = rFonts.getEastAsia();
        }
        ascii = rFonts.getAsciiTheme() != null && this.getThemePart() != null ? this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang) : rFonts.getAscii();
        hAnsi = rFonts.getHAnsiTheme() != null && this.getThemePart() != null ? this.getThemePart().getFont(rFonts.getHAnsiTheme(), this.themeFontLang) : rFonts.getHAnsi();
        if ("Times New Roman".equals(eastAsia) && ascii != null && ascii.equals(hAnsi)) {
            Element span = this.createElement(document);
            if (span != null) {
                document.appendChild(span);
            }
            if (this.outputType == RunFontActionType.DISCOVERY) {
                this.vis.fontAction(ascii);
                return null;
            }
            this.setAttribute(span, ascii);
            span.setTextContent(text);
            return this.result(document);
        }
        if (ascii == null) {
            log.warn("No value for ascii, using default font");
            ascii = this.getDefaultFont();
        }
        if (hAnsi == null) {
            log.warn("No value for hAnsi, using default font");
            hAnsi = this.getDefaultFont();
        }
        String langEastAsia = null;
        if (rPr.getLang() != null) {
            langEastAsia = rPr.getLang().getEastAsia();
        }
        this.vis.setDocument(document);
        return this.unicodeRangeToFont(text, hint, langEastAsia, eastAsia, ascii, hAnsi);
    }

    private Object unicodeRangeToFont(String text, STHint hint, String langEastAsia, String eastAsia, String ascii, String hAnsi) {
        int currentRangeLower = 0;
        int currentRangeUpper = 0;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            if (this.vis.isReusable() && (c == 32 || c >= currentRangeLower && c <= currentRangeUpper)) {
                this.vis.addCharacterToCurrent((char)c);
                continue;
            }
            this.vis.finishPrevious();
            this.vis.createNew();
            this.vis.setMustCreateNewFlag(false);
            if (c >= 0 && c <= 127) {
                this.vis.fontAction(ascii);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 0;
                currentRangeUpper = 127;
                continue;
            }
            if (c >= 160 && c <= 255) {
                if (hint == STHint.EAST_ASIA) {
                    if (langEastAsia.equals("zh")) {
                        if (c >= 224 && c <= 225 || c >= 232 && c <= 234 || c >= 236 && c <= 237 || c >= 242 && c <= 243 || c >= 249 && c <= 250 || c == 252) {
                            this.vis.fontAction(eastAsia);
                            this.vis.setMustCreateNewFlag(true);
                        } else {
                            this.vis.fontAction(hAnsi);
                        }
                    } else if (c == 161 || c == 164 || c >= 167 && c <= 168 || c == 170 || c == 173 || c == 175 || c >= 176 && c <= 180 || c >= 182 && c <= 186 || c >= 188 && c <= 191 || c == 215 || c == 247) {
                        this.vis.fontAction(eastAsia);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 0;
                currentRangeUpper = 127;
                continue;
            }
            if (c >= 256 && c <= 687) {
                if (hint == STHint.EAST_ASIA) {
                    if ("zh".equals(langEastAsia)) {
                        this.vis.fontAction(eastAsia);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                        this.vis.setMustCreateNewFlag(true);
                    }
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 256;
                currentRangeUpper = 687;
                continue;
            }
            if (c >= 688 && c <= 1279) {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 688;
                currentRangeUpper = 1279;
                continue;
            }
            if (c >= 1424 && c <= 1983) {
                this.vis.fontAction(ascii);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 1424;
                currentRangeUpper = 1983;
                continue;
            }
            if (c >= 4352 && c <= 4607) {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 4352;
                currentRangeUpper = 4607;
                continue;
            }
            if (c >= 7680 && c <= 7935) {
                if (hint == STHint.EAST_ASIA) {
                    if ("zh".equals(langEastAsia)) {
                        this.vis.fontAction(eastAsia);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 7680;
                currentRangeUpper = 7935;
                continue;
            }
            if (c >= 8192 && c <= 12031) {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 8192;
                currentRangeUpper = 12031;
                continue;
            }
            if (c >= 12032 && c <= 57343) {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 12032;
                currentRangeUpper = 57343;
                continue;
            }
            if (c >= 57344 && c <= 63743) {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 57344;
                currentRangeUpper = 63743;
                continue;
            }
            if (c >= 63744 && c <= 64255) {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 63744;
                currentRangeUpper = 64255;
                continue;
            }
            if (c >= 64256 && c <= 64335) {
                if (hint == STHint.EAST_ASIA) {
                    if (c >= 64256 && c <= 64284) {
                        this.vis.fontAction(eastAsia);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                } else if (c >= 64285 && c <= 64335) {
                    this.vis.fontAction(ascii);
                    this.vis.setMustCreateNewFlag(true);
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 64256;
                currentRangeUpper = 64335;
                continue;
            }
            if (c >= 64336 && c <= 65023) {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 64336;
                currentRangeUpper = 65023;
                continue;
            }
            if (c >= 65072 && c <= 65135) {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 65072;
                currentRangeUpper = 65135;
                continue;
            }
            if (c >= 65136 && c <= 65278) {
                this.vis.fontAction(ascii);
                this.vis.addCharacterToCurrent((char)c);
                currentRangeLower = 65136;
                currentRangeUpper = 65278;
                continue;
            }
            if (c < 65280 || c > 65519) continue;
            this.vis.fontAction(eastAsia);
            this.vis.addCharacterToCurrent((char)c);
            currentRangeLower = 65280;
            currentRangeUpper = 65519;
        }
        this.vis.finishPrevious();
        return this.vis.getResult();
    }

    private Document getDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getCssProperty(String fontName) {
        String font;
        if (log.isDebugEnabled() && fontName == null) {
            Throwable t = new Throwable();
            t.printStackTrace();
        }
        if ((font = this.getPhysicalFont(fontName)) != null) {
            return Property.composeCss("font-family", font);
        }
        log.warn("No mapping from " + font);
        return "";
    }

    private String getPhysicalFont(String fontName) {
        log.debug("looking for: " + fontName);
        PhysicalFont pf = this.wordMLPackage.getFontMapper().getFontMappings().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        String englishFromCJK = CJKToEnglish.toEnglish(fontName);
        if (englishFromCJK == null) {
            log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
            return null;
        }
        pf = this.wordMLPackage.getFontMapper().getFontMappings().get(englishFromCJK);
        if (pf == null) {
            log.warn("Font '" + englishFromCJK + "' is not mapped to a physical font. ");
            return null;
        }
        return pf.getName();
    }

    public static interface RunFontCharacterVisitor {
        public void setRunFontSelector(RunFontSelector var1);

        public void setDocument(Document var1);

        public void addCharacterToCurrent(char var1);

        public void finishPrevious();

        public void createNew();

        public void setMustCreateNewFlag(boolean var1);

        public boolean isReusable();

        public void fontAction(String var1);

        public void setFallbackFont(String var1);

        public Object getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunFontActionType {
        XSL_FO,
        XHTML,
        DISCOVERY;

    }
}

