% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgSnapshot.R
\name{pkgSnapshot}
\alias{pkgSnapshot}
\title{Take a snapshot of all the packages and version numbers}
\usage{
pkgSnapshot(
  packageVersionFile = "packageVersions.txt",
  libPaths,
  standAlone = FALSE
)
}
\arguments{
\item{packageVersionFile}{A filename to save the packages and their currently
installed version numbers. Defaults to \code{".packageVersions.txt"}.}

\item{libPaths}{The path to the local library where packages are installed.
Defaults to the \code{.libPaths()[1]}.}

\item{standAlone}{Logical. If \code{TRUE}, all packages will be installed to and loaded from
                  the \code{libPaths} only. If \code{FALSE}, then \code{libPath} will
                  be prepended to \code{.libPaths()} during the \code{Require} call,
                  resulting in shared packages, i.e.,
                  it will include the user's default package folder(s).
                  This can be create dramatically faster
installs if the user has a substantial number of the packages already in
their personal library. Default \code{FALSE} to minimize package installing.}
}
\description{
This can be used later by \code{installVersions} to install or re-install the correct versions.
}
\details{
A file is written with the package names and versions of all packages within \code{libPaths}.
This can later be passed to \code{Require}.
}
\examples{
pkgSnapFile <- tempfile()
pkgSnapshot(pkgSnapFile, .libPaths()[1])
data.table::fread(pkgSnapFile)

}
