% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Application.R
\name{Application}
\alias{Application}
\title{Creates application - RestRserve usage starts from here}
\description{
Creates Application object.
Application provides an interface for building high-performance
REST API by registering R functions as handlers http requests.
}
\details{
There are several advanced options to control how HTTP headers are
processed:
\itemize{
\item \code{options("RestRserve.headers.server")} controls response \code{"Server"} header
\item \code{options("RestRserve.headers.split")} controls which header values
split by comma during parsing. See
\url{https://en.wikipedia.org/wiki/List_of_HTTP_header_fields},
\url{https://stackoverflow.com/a/29550711/3048453}
}

There is also an option to switch-off runtime types validation in
the Request/Response handlers. This might provide some performance gains,
but ultimately leads to less robust applications. Use at your own risk!
See \code{options("RestRserve.runtime.asserts")}
}
\examples{
# init logger
app_logger = Logger$new()
# set log level for the middleware
app_logger$set_log_level("debug")
# set logger name
app_logger$set_name("MW Logger")
# init middleware to logging
mw = Middleware$new(
  process_request = function(rq, rs) {
    app_logger$info(sprintf("Incomming request (id \%s): \%s", rq$id, rq$path))
  },
  process_response = function(rq, rs) {
    app_logger$info(sprintf("Outgoing response (id \%s): \%s", rq$id, rs$status))
  },
  id = "awesome-app-logger"
)

# init application
app = Application$new(middleware = list(mw))

# set internal log level
app$logger$set_log_level("error")

# define simply request handler
status_handler = function(rq, rs) {
  rs$set_body("OK")
  rs$set_content_type("text/plain")
  rs$set_status_code(200L)
}
# add route
app$add_get("/status", status_handler, "exact")

# add static file handler
desc_file = system.file("DESCRIPTION", package = "RestRserve")
# add route
app$add_static("/desc", desc_file, "text/plain")

# define say message handler
say_handler = function(rq, rs) {
  who = rq$parameters_path[["user"]]
  msg = rq$parameters_query[["message"]]
  if (is.null(msg)) msg = "Hello"
  rs$set_body(paste(who, "say", dQuote(msg)))
  rs$set_content_type("text/plain")
  rs$set_status_code(200L)
}
# add route
app$add_get("/say/{user}", say_handler, "regex")

# print application info
app

# test app
# simulate requests
not_found_rq = Request$new(path = "/no")
status_rq = Request$new(path = "/status")
desc_rq = Request$new(path = "/desc")
say_rq = Request$new(path = "/say/anonym", parameters_query = list("message" = "Hola"))
# process prepared requests
app$process_request(not_found_rq)
app$process_request(status_rq)
app$process_request(desc_rq)
app$process_request(say_rq)

# run app
backend = BackendRserve$new()
\donttest{
if (interactive()) {
  backend$start(app, 8080)
}
}

}
\seealso{
\link{HTTPError} \link{Middleware}
\link{Request} \link{Response}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{logger}}{Logger object which records events during request processing.
Alternatively user can use loggers from lgr package as a drop-in
replacement - \code{Logger} methods and loggers created by \code{lgr} share
function signatures.}

\item{\code{content_type}}{Default response body content type.}

\item{\code{HTTPError}}{Class which raises HTTP errors.
Global \link{HTTPError} is used by default. In theory user can replace it with
his own class (see \code{RestRserve:::HTTPErrorFactory}). However we believe
in the majority of the cases using \link{HTTPError} will be enough.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{endpoints}}{Prints all the registered routes with allowed methods.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Application$new()}}
\item \href{#method-add_route}{\code{Application$add_route()}}
\item \href{#method-add_get}{\code{Application$add_get()}}
\item \href{#method-add_post}{\code{Application$add_post()}}
\item \href{#method-add_static}{\code{Application$add_static()}}
\item \href{#method-add_openapi}{\code{Application$add_openapi()}}
\item \href{#method-add_swagger_ui}{\code{Application$add_swagger_ui()}}
\item \href{#method-append_middleware}{\code{Application$append_middleware()}}
\item \href{#method-process_request}{\code{Application$process_request()}}
\item \href{#method-print}{\code{Application$print()}}
\item \href{#method-clone}{\code{Application$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates Application object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$new(
  middleware = list(EncodeDecodeMiddleware$new()),
  content_type = "text/plain",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{middleware}}{List of \link{Middleware} objects.}

\item{\code{content_type}}{Default response body content (media) type. \code{"text/plain"} by default.}

\item{\code{...}}{Not used at the moment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_route"></a>}}
\if{latex}{\out{\hypertarget{method-add_route}{}}}
\subsection{Method \code{add_route()}}{
Adds endpoint and register user-supplied R function as a handler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_route(
  path,
  method,
  FUN,
  match = c("exact", "partial", "regex"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Endpoint path.}

\item{\code{method}}{HTTP method. Allowed methods at the moment:
\code{GET}, \code{HEAD}, \code{POST}, \code{PUT}, \code{DELETE}, \code{OPTIONS}, \code{PATCH}.}

\item{\code{FUN}}{User function to handle requests. \code{FUN} \strong{must} take two arguments:
first is \code{request} (\link{Request}) and second is \code{response} (\link{Response}).\cr
The goal of the user function is to \strong{modify} \code{response} or throw
exception (call \code{\link[=raise]{raise()}} or \code{\link[=stop]{stop()}}).\cr
Both \code{response} and \code{request} objects modified in-place and internally
passed further to RestRserve execution pipeline.}

\item{\code{match}}{Defines how route will be processed. Allowed values:
\itemize{
\item \code{exact} - match route as is. Returns 404 if route is not matched.
\item \code{partial} - match route as prefix. Returns 404 if prefix are not matched.
\item \code{regex} - match route as template. Returns 404 if template pattern not matched.
}}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_get"></a>}}
\if{latex}{\out{\hypertarget{method-add_get}{}}}
\subsection{Method \code{add_get()}}{
Shorthand to \code{Application$add_route()} with \code{GET} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_get(
  path,
  FUN,
  match = c("exact", "partial", "regex"),
  ...,
  add_head = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Endpoint path.}

\item{\code{FUN}}{User function to handle requests. \code{FUN} \strong{must} take two arguments:
first is \code{request} (\link{Request}) and second is \code{response} (\link{Response}).\cr
The goal of the user function is to \strong{modify} \code{response} or throw
exception (call \code{\link[=raise]{raise()}} or \code{\link[=stop]{stop()}}).\cr
Both \code{response} and \code{request} objects modified in-place and internally
passed further to RestRserve execution pipeline.}

\item{\code{match}}{Defines how route will be processed. Allowed values:
\itemize{
\item \code{exact} - match route as is. Returns 404 if route is not matched.
\item \code{partial} - match route as prefix. Returns 404 if prefix are not matched.
\item \code{regex} - match route as template. Returns 404 if template pattern not matched.
}}

\item{\code{...}}{Not used.}

\item{\code{add_head}}{Adds HEAD method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_post"></a>}}
\if{latex}{\out{\hypertarget{method-add_post}{}}}
\subsection{Method \code{add_post()}}{
Shorthand to \code{Application$add_route()} with \code{POST} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_post(path, FUN, match = c("exact", "partial", "regex"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Endpoint path.}

\item{\code{FUN}}{User function to handle requests. \code{FUN} \strong{must} take two arguments:
first is \code{request} (\link{Request}) and second is \code{response} (\link{Response}).\cr
The goal of the user function is to \strong{modify} \code{response} or throw
exception (call \code{\link[=raise]{raise()}} or \code{\link[=stop]{stop()}}).\cr
Both \code{response} and \code{request} objects modified in-place and internally
passed further to RestRserve execution pipeline.}

\item{\code{match}}{Defines how route will be processed. Allowed values:
\itemize{
\item \code{exact} - match route as is. Returns 404 if route is not matched.
\item \code{partial} - match route as prefix. Returns 404 if prefix are not matched.
\item \code{regex} - match route as template. Returns 404 if template pattern not matched.
}}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_static"></a>}}
\if{latex}{\out{\hypertarget{method-add_static}{}}}
\subsection{Method \code{add_static()}}{
Adds \code{GET} method to serve file or directory at \code{file_path}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_static(path, file_path, content_type = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Endpoint path.}

\item{\code{file_path}}{Path file or directory.}

\item{\code{content_type}}{MIME-type for the content.\cr
If \code{content_type = NULL} then MIME code \code{content_type}  will be inferred
automatically (from file extension).\cr
If it will be impossible to guess about file type then \code{content_type} will
be set to \code{application/octet-stream}.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_openapi"></a>}}
\if{latex}{\out{\hypertarget{method-add_openapi}{}}}
\subsection{Method \code{add_openapi()}}{
Adds endpoint to serve \href{https://www.openapis.org/}{OpenAPI} description of
available methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_openapi(path = "/openapi.yaml", file_path = "openapi.yaml")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path Endpoint path.}

\item{\code{file_path}}{Path to the OpenAPI specification file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_swagger_ui"></a>}}
\if{latex}{\out{\hypertarget{method-add_swagger_ui}{}}}
\subsection{Method \code{add_swagger_ui()}}{
Adds endpoint to show \href{https://swagger.io/tools/swagger-ui/}{Swagger UI}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$add_swagger_ui(
  path = "/swagger",
  path_openapi = "/openapi.yaml",
  use_cdn = TRUE,
  path_swagger_assets = "/__swagger__/",
  file_path = "swagger-ui.html"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path Endpoint path.}

\item{\code{path_openapi}}{Path to the OpenAPI specification file.}

\item{\code{use_cdn}}{Use CDN to load Swagger UI libraries.}

\item{\code{path_swagger_assets}}{Swagger UI asstes endpoint.}

\item{\code{file_path}}{Path to Swagger UI HTML file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append_middleware"></a>}}
\if{latex}{\out{\hypertarget{method-append_middleware}{}}}
\subsection{Method \code{append_middleware()}}{
Appends middleware to handlers pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$append_middleware(mw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mw}}{\link{Middleware} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-process_request"></a>}}
\if{latex}{\out{\hypertarget{method-process_request}{}}}
\subsection{Method \code{process_request()}}{
Process incoming request and generate \link{Response} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$process_request(request = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{\link{Request} object.\cr
Useful for tests your handlers before deploy application.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints application details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Application$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
