% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{multilayer-forestry}
\alias{multilayer-forestry}
\alias{multilayerForestry}
\title{Multilayer forestry}
\usage{
multilayerForestry(
  x,
  y,
  ntree = 500,
  nrounds = 1,
  eta = 0.3,
  replace = FALSE,
  sampsize = nrow(x),
  sample.fraction = NULL,
  mtry = ncol(x),
  nodesizeSpl = 3,
  nodesizeAvg = 3,
  nodesizeStrictSpl = max(round(nrow(x)/128), 1),
  nodesizeStrictAvg = max(round(nrow(x)/128), 1),
  minSplitGain = 0,
  maxDepth = 99,
  splitratio = 1,
  seed = as.integer(runif(1) * 1000),
  verbose = FALSE,
  nthread = 0,
  splitrule = "variance",
  middleSplit = TRUE,
  maxObs = length(y),
  linear = FALSE,
  linFeats = 0:(ncol(x) - 1),
  monotonicConstraints = rep(0, ncol(x)),
  featureWeights = rep(1, ncol(x)),
  deepFeatureWeights = featureWeights,
  observationWeights = NULL,
  overfitPenalty = 1,
  doubleTree = FALSE,
  reuseforestry = NULL,
  savable = TRUE,
  saveable = saveable
)
}
\arguments{
\item{x}{A data frame of all training predictors.}

\item{y}{A vector of all training responses.}

\item{ntree}{The number of trees to grow in the forest. The default value is
500.}

\item{nrounds}{Number of iterations used for gradient boosting.}

\item{eta}{Step size shrinkage used in gradient boosting update.}

\item{replace}{An indicator of whether sampling of training data is with
replacement. The default value is TRUE.}

\item{sampsize}{The size of total samples to draw for the training data. If
sampling with replacement, the default value is the length of the training
data. If samplying without replacement, the default value is two-third of
the length of the training data.}

\item{sample.fraction}{if this is given, then sampsize is ignored and set to
be round(length(y) * sample.fraction). It must be a real number between 0
and 1}

\item{mtry}{The number of variables randomly selected at each split point.
The default value is set to be one third of total number of features of the
training data.}

\item{nodesizeSpl}{Minimum observations contained in terminal nodes. The
default value is 3.}

\item{nodesizeAvg}{Minimum size of terminal nodes for averaging dataset. The
default value is 3.}

\item{nodesizeStrictSpl}{Minimum observations to follow strictly in terminal
nodes. The default value is 1.}

\item{nodesizeStrictAvg}{Minimum size of terminal nodes for averaging dataset
to follow strictly. The default value is 1.}

\item{minSplitGain}{Minimum loss reduction to split a node further in a tree.}

\item{maxDepth}{Maximum depth of a tree. The default value is 99.}

\item{splitratio}{Proportion of the training data used as the splitting
dataset. It is a ratio between 0 and 1. If the ratio is 1, then essentially
splitting dataset becomes the total entire sampled set and the averaging
dataset is empty. If the ratio is 0, then the splitting data set is empty
and all the data is used for the averaging data set (This is not a good
usage however since there will be no data available for splitting).}

\item{seed}{random seed}

\item{verbose}{if training process in verbose mode}

\item{nthread}{Number of threads to train and predict the forest. The default
number is 0 which represents using all cores.}

\item{splitrule}{only variance is implemented at this point and it contains
specifies the loss function according to which the splits of random forest
should be made}

\item{middleSplit}{if the split value is taking the average of two feature
values. If false, it will take a point based on a uniform distribution
between two feature values. (Default = FALSE)}

\item{maxObs}{The max number of observations to split on}

\item{linear}{Fit the model with a ridge regression or not}

\item{linFeats}{Specify which features to split linearly on when using
linear (defaults to use all numerical features)}

\item{monotonicConstraints}{Specifies monotonic relationships between the
continuous features and the outcome. Supplied as a vector of length p with
entries in 1,0,-1 which 1 indicating an increasing monotonic relationship,
-1 indicating a decreasing monotonic relationship, and 0 indicating no
relationship. Constraints supplied for categorical will be ignored.}

\item{featureWeights}{weights used when subsampling features for nodes above or at interactionDepth.}

\item{deepFeatureWeights}{weights used when subsampling features for nodes below interactionDepth.}

\item{observationWeights}{These denote the weights for each training observation
which determines how likely the observation is to be selected in each bootstrap
sample. This option is not allowed when sampling is done without replacement.}

\item{overfitPenalty}{Value to determine how much to penalize magnitude of
coefficients in ridge regression}

\item{doubleTree}{if the number of tree is doubled as averaging and splitting
data can be exchanged to create decorrelated trees. (Default = FALSE)}

\item{reuseforestry}{pass in an `forestry` object which will recycle the
dataframe the old object created. It will save some space working on the
same dataset.}

\item{savable}{If TRUE, then RF is created in such a way that it can be
saved and loaded using save(...) and load(...). Setting it to TRUE
(default) will, however, take longer and it will use more memory. When
training many RF, it makes a lot of sense to set this to FALSE to save
time and memory.}

\item{saveable}{deprecated. Do not use.}
}
\value{
A `multilayerForestry` object.
}
\description{
Construct a gradient boosted random forest.
}
