% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_ga4gh.R
\name{post_ga4gh}
\alias{post_ga4gh}
\title{POST to a GA4GH Server}
\usage{
post_ga4gh(client, operation, body)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{operation}{The API operation to POST to as a string. Eg "/datasets/search"}

\item{body}{The body of the POST either as JSON or a list (which will be converted to json by httr)}
}
\description{
Use this to POST a request to an operation.
 The operations should simply be specified as a path in the API i.e. "/datasets/search" to search datasets.
 The body can be json or an R list.
 Use the search_* functions for a simpler interface.
}
\examples{
## Create a client
ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "", log_level = 1)

## A request body as a list
body_list <- list(pageSize = 2)

\dontrun{
## Post to the /datasets/search operation
datasets_list <- ref_client \%>\% post_ga4gh("/datasets/search", body_list) \%>\% content
datasets_list

}

}

