% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_power_cont.R
\name{chi_power_cont}
\alias{chi_power_cont}
\title{This function finds the power of various chi-square tests for continuous data}
\usage{
chi_power_cont(
  pnull,
  ralt,
  param_alt,
  qnull = NA,
  phat = function(x) -99,
  w = function(x) -99,
  alpha = 0.05,
  Range = c(-99999, 99999),
  B = 1000,
  nbins = c(50, 10),
  rate = 0,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{qnull}{=NA function to find quantiles under null hypothesis, if available}

\item{phat}{=function(x) -99, function to estimate parameters}

\item{w}{=function(x) -99, optional weight function}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Range}{=c(-99999, 99999) limits of possible observations, if any}

\item{B}{=1000 number of simulation runs to find power}

\item{nbins}{=c(50,10), number of bins for chi square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{=TRUE, if TRUE param is estimated parameters and no minimization is used}
}
\value{
A numeric matrix of power values.
}
\description{
This function finds the power of various chi-square tests for continuous data
}
