# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' sort vector y by values in vector x
#' 
#' @param y numeric vector
#' @param x numeric vector
#' @keywords internal
#' @return numeric vector
Cpporder <- function(y, x) {
    .Call(`_Rgof_Cpporder`, y, x)
}

#' Find test statistics for continuous data
#' 
#' @param x A numeric vector.
#' @param pnull cdf.
#' @param param parameters for pnull  in case of parameter estimation.
#' @param qnull An R function, the quantile function under the null hypothesis.
#' @return A numeric vector with test statistics
TS_cont <- function(x, pnull, param, qnull) {
    .Call(`_Rgof_TS_cont`, x, pnull, param, qnull)
}

#' Find test statistics for discrete data
#' 
#' @param x An integer vector.
#' @param pnull cdf.
#' @param param parameters for pnull in case of parameter estimation.
#' @param vals A numeric vector with the values of the discrete rv.
#' @return A vector with test statistics
TS_disc <- function(x, pnull, param, vals) {
    .Call(`_Rgof_TS_disc`, x, pnull, param, vals)
}

#' Find test statistics for continuous data with weights
#' 
#' @param x A numeric vector.
#' @param pnull cdf.
#' @param param parameters for pnull in case of parameter estimation.
#' @param w numeric vector of weights
#' @keywords internal
#' @return A numeric vector with test statistics
TSw_cont <- function(x, pnull, param, w) {
    .Call(`_Rgof_TSw_cont`, x, pnull, param, w)
}

#' Find test statistics for discrete data
#' 
#' @param x An integer vector.
#' @param pnull cdf.
#' @param param parameters for pnull in case of parameter estimation.
#' @param vals A numeric vector with the values of the discrete rv.
#' @param w weights 
#' @keywords internal
#' @return A vector with test statistics
TSw_disc <- function(x, pnull, param, vals, w) {
    .Call(`_Rgof_TSw_disc`, x, pnull, param, vals, w)
}

#' count events in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @keywords internal
#' @return Integer vector of counts
bincounter <- function(x, bins) {
    .Call(`_Rgof_bincounter`, x, bins)
}

#' run gof tests for continuous data
#' 
#' @param x A numeric vector of data
#' @param pnull R function (cdf)
#' @param rnull R function (generate data under null hypothesis)
#' @param phat  function to set or estimate parameters of pnull 
#' @param TS function that calculates test statistics
#' @param typeTS integer indicating type of test statistic
#' @param TSextra list to pass to TS
#' @param B (=5000) Number of simulation runs 
#' @keywords internal
#' @return A matrix of numbers
gof_cont <- function(x, pnull, rnull, phat, TS, typeTS, TSextra, B = 5000L) {
    .Call(`_Rgof_gof_cont`, x, pnull, rnull, phat, TS, typeTS, TSextra, B)
}

#' run gof tests for discrete data
#' 
#' @param x an integer vector of counts
#' @param pnull cumulative distribution function under the null hypothesis
#' @param rnull R function (generate data under null hypothesis)
#' @param vals numeric vector of values of discrete random variables.
#' @param phat function to estimate parameters
#' @param TS function that calculates test statistics
#' @param typeTS type of test statistic
#' @param TSextra list passed to TS, if desired
#' @param rate =0, rate of sample size, if random
#' @param B (=5000) Number of simulation runs  
#' @keywords internal
#' @return A matrix of numbers
gof_disc <- function(x, pnull, rnull, vals, phat, TS, typeTS, TSextra, rate = 0.0, B = 5000L) {
    .Call(`_Rgof_gof_disc`, x, pnull, rnull, vals, phat, TS, typeTS, TSextra, rate, B)
}

#' a local function needed for the vignette
#' 
#' @param x An integer vector.
#' @param pnull cdf.
#' @param param parameters for pnull in case of parameter estimation.
#' @param vals A numeric vector with the values of the discrete rv.
#' @return A vector with test statistics
#' @export
newTSdisc <- function(x, pnull, param, vals) {
    .Call(`_Rgof_newTSdisc`, x, pnull, param, vals)
}

#' find power of gof tests for continuous data
#' 
#' @param pnull R function (cdf)
#' @param rnull R function (generate data under null hypothesis)
#' @param ralt  R function to generate data under alternative
#' @param param_alt parameters of ralt
#' @param phat  function to estimate parameters from the data
#' @param TS function to calculate test statistics
#' @param typeTS integer indicating type of test statistic
#' @param TSextra list to pass to TS
#' @param B  =1000 Number of simulation runs
#' @keywords internal
#' @return A matrix of powers
power_cont <- function(pnull, rnull, ralt, param_alt, phat, TS, typeTS, TSextra, B = 1000L) {
    .Call(`_Rgof_power_cont`, pnull, rnull, ralt, param_alt, phat, TS, typeTS, TSextra, B)
}

#' find power of gof tests for continuous data
#' 
#' @param pnull R function (cdf)
#' @param rnull R function (generate data under null hypothesis)
#' @param vals values of discrete distribution
#' @param ralt  R function to generate data under alternative
#' @param param_alt parameters of ralt
#' @param phat  function to estimate parameters from the data
#' @param TS function to calculate test statistics
#' @param typeTS integer indicating type of test statistic
#' @param TSextra list to pass to TS
#' @param B  =1000 Number of simulation runs
#' @keywords internal
#' @return A matrix of powers
power_disc <- function(pnull, rnull, vals, ralt, param_alt, phat, TS, typeTS, TSextra, B = 1000L) {
    .Call(`_Rgof_power_disc`, pnull, rnull, vals, ralt, param_alt, phat, TS, typeTS, TSextra, B)
}

#' This function calculates the test statistics
#' @param  dta list with data set
#' @param  pnull  cdf under the null hypothesis
#' @param  param estimated parameters (or some constant)
#' @param  TS routine
#' @param  typeTS format of TS 
#' @param  TSextra list passed to TS function
#' @keywords internal
#' @return A vector of numbers
calcTS <- function(dta, pnull, param, TS, typeTS, TSextra) {
    .Call(`_Rgof_calcTS`, dta, pnull, param, TS, typeTS, TSextra)
}

#' Find counts or sum of weights in bins. Useful for power calculations. Replaces hist command from R.
#' 
#' @param x numeric vector
#' @param bins numeric vector
#' @param w numeric vector of weights 
#' @keywords internal
#' @return sum of weights in bins
wbincounter <- function(x, bins, w) {
    .Call(`_Rgof_wbincounter`, x, bins, w)
}

