% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_sphere.R
\name{mixspnorm}
\alias{mixspnorm}
\title{Finite Mixture of Spherical Normal Distributions}
\usage{
mixspnorm(
  data,
  k = 2,
  same.lambda = FALSE,
  variants = c("soft", "hard", "stochastic"),
  ...
)
}
\arguments{
\item{data}{data vectors in form of either an \eqn{(n\times p)} matrix or a length-\eqn{n} list.  See \code{\link{wrap.sphere}} for descriptions on supported input types.}

\item{k}{the number of clusters (default: 2).}

\item{same.lambda}{a logical; \code{TRUE} to use same concentration parameter across all components, or \code{FALSE} otherwise.}

\item{variants}{type of the class assignment methods, one of \code{"soft"},\code{"hard"}, and \code{"stochastic"}.}

\item{...}{extra parameters including \describe{
\item{maxiter}{the maximum number of iterations (default: 50).}
\item{eps}{stopping criterion for the EM algorithm (default: 1e-6).}
\item{printer}{a logical; \code{TRUE} to show history of the algorithm, \code{FALSE} otherwise.}
}}
}
\value{
a named list of S3 class \code{mixspnorm} containing
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).}
\item{loglkd}{log likelihood of the fitted model.}
\item{criteria}{a vector of information criteria.}
\item{parameters}{a list containing \code{proportion}, \code{center}, and \code{concentration}. See the section for more details.}
\item{membership}{an \eqn{(n\times k)} row-stochastic matrix of membership.}
}
}
\description{
For \eqn{n} observations on a \eqn{(p-1)} sphere in \eqn{\mathbf{R}^p}, 
a finite mixture model is fitted whose components are spherical normal distributions via the following model
\deqn{f(x; \left\lbrace w_k, \mu_k, \lambda_k \right\rbrace_{k=1}^K) = \sum_{k=1}^K w_k SN(x; \mu_k, \lambda_k)}
with parameters \eqn{w_k}'s for component weights, \eqn{\mu_k}'s for component locations, and \eqn{\lambda_k}'s for component concentrations.
}
\section{Parameters of the fitted model}{

A fitted model is characterized by three parameters. For \eqn{k}-mixture model on a \eqn{(p-1)} 
sphere in \eqn{\mathbf{R}^p}, (1) \code{proportion} is a length-\eqn{k} vector of component weight 
that sums to 1, (2) \code{center} is an \eqn{(k\times p)} matrix whose rows are cluster centers, and 
(3) \code{concentration} is a length-\eqn{k} vector of concentration parameters for each component.
}

\examples{
\donttest{
# LOAD THE CITY DATA AND WRAP AS RIEMOBJ
data(cities)
locations = cities$cartesian
embed2    = array(0,c(60,2)) 
for (i in 1:60){
   embed2[i,] = sphere.xyz2geo(locations[i,])
}

# FIT THE MODEL WITH DIFFERENT K's
k2 = mixspnorm(locations, k=2)
k3 = mixspnorm(locations, k=3)
k4 = mixspnorm(locations, k=4)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(embed2, col=k2$cluster, pch=19, main="K=2")
plot(embed2, col=k3$cluster, pch=19, main="K=3")
plot(embed2, col=k4$cluster, pch=19, main="K=4")
par(opar)
}

}
\concept{sphere}
