% Generated by roxygen2 (4.1.0.9000): do not edit by hand
% Please edit documentation in R/submitShare.R
\name{submitShare}
\alias{submitShare}
\title{Share an update to your network's activity feed}
\usage{
submitShare(token, comment = NULL, content_title = NULL,
  content_desc = NULL, content_url = NULL, content_img = NULL,
  visibility = "anyone")
}
\arguments{
\item{token}{Authorization token.}

\item{comment}{Headline of your post.}

\item{content_title}{Title of your post.}

\item{content_desc}{Description of your post.}

\item{content_url}{Url to content you'd like to share. This is required if you specify either \code{content_title} or \code{content_desc}.}

\item{content_img}{Url to an image you would like to include in your post, optional.}

\item{visibility}{Choose the visibility of the post. The choices are 'anyone' or 'connections-only'.}
}
\value{
Shares an update to your networks's activity feed.
}
\description{
\code{submitShare} will post a network update to the newsfeed of your connections.  You can select the visibility of your post to be seen either by 'anyone' or 'connections-only'.
}
\details{
If either \code{content_title} or \code{content_desc} is specified, you must also include a \code{content_url} for the post.
}
\examples{
\dontrun{

comment <- "Test connecting to the LinkedIn API via R"
title <- "Im creating an R package to connect to the LinkedIn API, this is a test post from R!"
url <- "https://github.com/mpiccirilli"
desc <- "Dev version of access to LinkedIn API via R. Collaboration is welcomed!"

submitShare(token = in.auth, comment=comment, content_tile=title,
            content_url=url, content_desc=desc)
}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{submitGroupPost}}
}

