% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R, R/Model.R, R/MultinomialParameter.R,
%   R/GaussianParameter.R, R/CompositeParameter.R, R/MixmodResults.R,
%   R/Mixmod.R, R/Strategy.R, R/MixmodCluster.R, R/MixmodDAResults.R,
%   R/MixmodLearn.R, R/MixmodPredict.R
\docType{methods}
\name{print}
\alias{print}
\alias{print,Model-method}
\alias{print,MultinomialParameter-method}
\alias{print,GaussianParameter-method}
\alias{print,CompositeParameter-method}
\alias{print,MixmodResults-method}
\alias{print,Mixmod-method}
\alias{print,Strategy-method}
\alias{print,MixmodCluster-method}
\alias{print,MixmodDAResults-method}
\alias{print,MixmodLearn-method}
\alias{print,MixmodPredict-method}
\title{Print a Rmixmod class to standard output.}
\usage{
\S4method{print}{Model}(x, ...)

\S4method{print}{MultinomialParameter}(x, ...)

\S4method{print}{GaussianParameter}(x, ...)

\S4method{print}{CompositeParameter}(x, ...)

\S4method{print}{MixmodResults}(x, ...)

\S4method{print}{Mixmod}(x, ...)

\S4method{print}{Strategy}(x, ...)

\S4method{print}{MixmodCluster}(x, ...)

\S4method{print}{MixmodDAResults}(x, ...)

\S4method{print}{MixmodLearn}(x, ...)

\S4method{print}{MixmodPredict}(x, ...)
}
\arguments{
\item{x}{a Rmixmod object: a \code{\linkS4class{Strategy}}, a \code{\linkS4class{Model}}, a
\code{\linkS4class{GaussianParameter}}, a \code{\linkS4class{MultinomialParameter}}, a \code{\linkS4class{MixmodResults}},
a \code{\linkS4class{MixmodCluster}}, a \code{\linkS4class{MixmodLearn}} or a \code{\linkS4class{MixmodPredict}}.}

\item{...}{further arguments passed to or from other methods}
}
\value{
NULL. Prints to standard out.
}
\description{
Print a Rmixmod class to standard output.
}
\examples{
## for strategy
strategy <- mixmodStrategy()
print(strategy)

## for Gaussian models
gmodel <- mixmodGaussianModel()
print(gmodel)
## for multinomial models
mmodel <- mixmodMultinomialModel()
print(mmodel)

## for clustering
data(geyser)
xem <- mixmodCluster(geyser, 3)
print(xem)
## for Gaussian parameters
print(xem["bestResult"]["parameters"])

## for discriminant analysis
# start by extract 10 observations from iris data set
iris.partition <- sample(1:nrow(iris), 10)
# then run a mixmodLearn() analysis without those 10 observations
learn <- mixmodLearn(iris[-iris.partition, 1:4], iris$Species[-iris.partition])
# print learn results
print(learn)
# create a MixmodPredict to predict those 10 observations
prediction <- mixmodPredict(
  data = iris[iris.partition, 1:4],
  classificationRule = learn["bestResult"]
)
# print prediction results
print(prediction)
}
\seealso{
\code{\link{print}}
}
