% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rmixmod.R
\docType{data}
\name{finance}
\alias{finance}
\title{Composite data: Financial health of companies}
\format{
A data frame with 889 companies (rows) and 6 variables (columns).

\describe{

  \item{\code{Year}}{categorical variable with two modalities (2002 & 2003).}

  \item{\code{Health}}{categorical variable with two modalities (bankruptcy & healthy).}

  \item{\code{EBITDA.Total.Assets}}{numeric variable.}

  \item{\code{Value.Added.Total.Sales}}{numeric variable.}

  \item{\code{Quick.Ratio}}{numeric variable.}

  \item{\code{Accounts.Payable.Total.Sales}}{numeric variable.}
}
}
\source{
Lourme A, Biernacki C (2011). \emph{Simultaneous t-Model-Based Clustering for Data Differing over Time Period: Application
for Understanding Companies Financial Health.} Case Studies in Business, Industry and Government Statistics, 4(2), 73-82.

Du Jardin P, S\'everin E (2010). \emph{Dynamic analysis of the business failure process: a study of bankruptcy
trajectories.} In Portuguese Finance Network. Ponte Delgada, Portugal.
}
\description{
This data set is made up of 216 healthy firms and 212 bankruptcy firms (year 2002) and also 241 healthy firms and 220
bankruptcy firms (year 2003). Companies are described by four financial ratios expected to provide some meaningful
information about their health: EBITDA/Total Assets, Value Added/Total Sales, Quick Ratio, Accounts Payable/Total Sales.
This data set offers the possibility to predict the company's ability to cover its financial obligations and also to study
its stability over the years.
}
\examples{
data(finance)
summary(finance)
}
\keyword{datasets}
