% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-harmonized_data_evaluate.R
\name{dataschema_evaluate}
\alias{dataschema_evaluate}
\title{Generate an assessment report for a DataSchema}
\usage{
dataschema_evaluate(dataschema, taxonomy = NULL)
}
\arguments{
\item{dataschema}{A DataSchema object.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}
}
\value{
A list of data frames containing assessment reports.
}
\description{
Assesses the content and structure of a DataSchema object and generates
reports of the results. This function can be used to evaluate data structure,
presence of specific fields, coherence across elements, and data dictionary
formats.
}
\details{
A DataSchema is the list of core variables to generate across datasets and
related metadata. A DataSchema object is a list of data frames with elements
named 'Variables' (required) and 'Categories' (if any). The 'Variables'
element must contain at least the \code{name} column, and the 'Categories'
element must contain at least the \code{variable} and \code{name} columns to be usable
in any function. In 'Variables' the \code{name} column must also have unique
entries, and in 'Categories' the combination of \code{variable} and \code{name} columns
must also be unique.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal//}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.
}
\examples{
{

# use Rmonize_DEMO provided by the package

library(dplyr)
library(madshapR) # data_dict_filter

dataschema <- 
  Rmonize_DEMO$`dataschema - final` \%>\%
  data_dict_filter("name == 'adm_unique_id'")
  
dataschema_evaluate(dataschema)

}

}
