% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rnet_classes.R
\docType{class}
\name{rnetInput-class}
\alias{rnetInput-class}
\alias{rnetInput}
\alias{rnet.L1.set-class}
\alias{rnet.L1.set}
\title{An S4 class for accepting input data common for generating all rnet objects. These objects are used to handle rnet objects and need not be called by the user.}
\description{
An S4 class for accepting input data common for generating all rnet objects. These objects are used to handle rnet objects and need not be called by the user.

See "L1_selection" documentation for more information.
}
\section{Slots}{

\describe{
\item{\code{RawData}}{A dataframe containing the original dataset.}

\item{\code{cor_method}}{The type of correlation matrix to use. Must be a partial match to one of the following strings: 'pearson', 'spearman', 'kendall'.}

\item{\code{cor_pairing}}{Method for handling how missing data is handled in pairs. See 'pair' argument in function 'cor' for more information.}

\item{\code{n_threshold}}{The minimum number of valid pair-wise observations that must exist for an edge to be estimated. Vertex pairs with fewer valid pair-wise observations are assumed to be conditiontally independent.}

\item{\code{L1_orig}}{The declared L1 penalty to be used when estimating rnet topology}

\item{\code{v_set_orig}}{The declared set of k variables to be included in the rnet as vertices}

\item{\code{Forced_zeros}}{A matrix with 2 columns containing pairs of vertices to force to be conditionally independent in the rnet}

\item{\code{Layout_master}}{A k x 2 matrix x & y coordinates of each vertex in the graph.}

\item{\code{Data}}{A dataframe containing the dataset}

\item{\code{L1_set}}{a numeric vector containing the candidate L1 penalties}

\item{\code{B}}{The number of subsamples to draw from the data to evaluate topologic stability}

\item{\code{B_method}}{Assigned either "proportionate" or "Total number" depending on how subsample size is determined.}

\item{\code{B_sets}}{A matrix (n_B x B) containing the rownumbers of the subsamples}

\item{\code{Data_b}}{An arrary (n_b x k x B) containing the data from the B_sets matrix}

\item{\code{pr_b}}{The size of the subsample B as a proportion of the complete dataset}

\item{\code{n_b}}{The size of the subsample}

\item{\code{W_aggr}}{An array (k x k x B x L1) containg all the weighted adjacency matrices generated by the all of subsamples over the L1 penalties}

\item{\code{A_aggr}}{An array (k x k x B x L1) containg all the adjacency matrices generated by the all of subsamples over the L1 penalties}

\item{\code{M}}{A dataframe with with graphical density data over the set of generated networks.}

\item{\code{Edge_stability}}{A dataframe showing edge stability over the set of generated networks.}

\item{\code{StARS_D}}{A vector of D_b values used for L1 selection.}
}}

