#' Hearing data
#'
#' Prevalence rates in percent for men aged 55–64 with hearing levels
#' 16 decibels or more above the audiometric zero.
#'
#' Format: Two-way ANOVA.
#' Description: The rows correspond to different frequencies and to normal speech.
#' 1. 500 hertz
#' 2. 1000 hertz
#' 3. 2000 hertz
#' 4. 3000 hertz
#' 5. 4000 hertz
#' 6. 6000 hertz
#' 7. Normal speech
#' The columns classify the data in seven occupational groups:
#' 1. professional–managerial
#' 2. farm
#' 3. clerical sales
#' 4. craftsmen
#' 5. operatives
#' 6. service
#' 7. laborers
#'
#' @docType data
#'
#' @usage data(hearing)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @source Roberts, J. and Cohrssen, J. (1968), Hearing
#' levels of adults, US National Center for Health Statistics Publications,
#' Series 11, No. 31
#'
#' @examples
#' data(hearing)
"hearing"
