% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{robyn_mmm}
\alias{robyn_mmm}
\title{Core MMM Function}
\usage{
robyn_mmm(
  InputCollect,
  hyper_collect,
  iterations,
  cores,
  nevergrad_algo,
  intercept_sign,
  add_penalty_factor = FALSE,
  dt_hyper_fixed = NULL,
  refresh = FALSE,
  seed = 123L,
  quiet = FALSE
)
}
\arguments{
\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{hyper_collect}{List. Containing hyperparameter bounds. Defaults to
\code{InputCollect$hyperparameters}.}

\item{iterations}{Integer. Number of iterations to run.}

\item{cores}{Integer. Default to \code{parallel::detectCores()} (max cores).}

\item{nevergrad_algo}{Character. Default to "TwoPointsDE". Options are
\code{c("DE","TwoPointsDE", "OnePlusOne", "DoubleFastGADiscreteOnePlusOne",
"DiscreteOnePlusOne", "PortfolioDiscreteOnePlusOne", "NaiveTBPSA",
"cGA", "RandomSearch")}.}

\item{intercept_sign}{Character. Choose one of "non_negative" (default) or
"unconstrained". By default, if intercept is negative, Robyn will drop intercept
and refit the model. Consider changing intercept_sign to "unconstrained" when
there are \code{context_vars} with large positive values.}

\item{add_penalty_factor}{Boolean. Add penalty factor hyperparameters to
glmnet's penalty.factor to be optimized by nevergrad. Use with caution, because
this feature might add too much hyperparameter space and probably requires
more iterations to converge.}

\item{dt_hyper_fixed}{data.frame. Only provide when loading old model results.
It consumes hyperparameters from saved csv \code{pareto_hyperparameters.csv}.}

\item{refresh}{Boolean. Set to \code{TRUE} when used in \code{robyn_refresh()}.}

\item{seed}{Integer. For reproducible results when running nevergrad.}

\item{quiet}{Boolean. Keep messages off?}
}
\value{
List. MMM results with hyperparameters values.
}
\description{
\code{robyn_mmm()} function activates Nevergrad to generate samples of
hyperparameters, conducts media transformation within each loop, fits the
Ridge regression, calibrates the model optionally, decomposes responses
and collects the result. It's an inner function within \code{robyn_run()}.
}
