% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_outliers_mcd.R
\name{plot_outliers_mcd}
\alias{plot_outliers_mcd}
\title{Plotting function for the MCD}
\usage{
plot_outliers_mcd(res, x, pos_display = FALSE)
}
\arguments{
\item{res}{result of the outliers_mad function from which we want to create a plot}

\item{x}{matrix of bivariate values from which we want to compute outliers}

\item{pos_display}{set whether the position of outliers in the dataset should be displayed on the graph (pos_display = TRUE)
or not (pos_display = FALSE)}
}
\value{
None
}
\description{
plotting data and highlighting multivariate outliers detected with the MCD function
Additionnally, the plot return two regression lines: the first one including all data and
the second one including all observations but the detected outliers. It allows to observe how much the outliers
influence of outliers on the regression line.
}
\examples{
#### Run plot_outliers_mcd
data(Attacks)
SOC <- rowMeans(Attacks[,c("soc1r","soc2r","soc3r","soc4","soc5","soc6",
"soc7r","soc8","soc9","soc10r","soc11","soc12","soc13")])
HSC <- rowMeans(Attacks[,22:46])
res <- outliers_mcd(x = cbind(SOC,HSC),na.rm=TRUE)
plot_outliers_mcd(res,x = cbind(SOC,HSC))

# it's also possible to display the position of the multivariate outliers ion the graph
# preferably, when the number of multivariate outliers is not too high
c1 <- c(1,4,3,6,5,2,1,3,2,4,7,3,6,3,4,6)
c2 <- c(1,3,4,6,5,7,1,4,3,7,50,8,8,15,10,6)
res2 <- outliers_mcd(x = cbind(c1,c2),na.rm=TRUE)
plot_outliers_mcd(res2, x=cbind(c1,c2),pos_display=TRUE)

# When no outliers are detected, only one regression line is displayed
c3 <- c(1,2,3,1,4,3,6,5)
c4 <- c(1,2,3,1,3,4,6,5)
res3 <- outliers_mcd(x = cbind(c3,c4),na.rm=TRUE)
plot_outliers_mcd(res3,x=cbind(c3,c4),pos_display=TRUE)
}
\keyword{MMCD}
\keyword{outliers}
\keyword{plot}
