% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Intention.R
\docType{data}
\name{Intention}
\alias{Intention}
\title{Study five of Rogers, T. & Milkman, K. L. (2016). Reminders through association. Psychological Science, 27, 973-986.}
\format{\describe{
  \item{age}{age}
  \item{choice}{Did participants choose to have a reminder? (1 = yes; 0 = no). Note that in conditions 2 and 4, participants had no choices and therefore, 0 is coded for all subjects in these two conditions}
  \item{Condition}{
  Condition 1 = free-reminder-through-association condition: participants read that they can choose to have (for free) an image of an elephant (presented on screen) that would appear at the bottom of page 11 as a reminder of selecting answer E;
  Condition 2 = non condition: no reminders;
  Condition 3 = costly-reminder-through-association condition: participants read that if they pay $0.03, an image of an elephant (presented on screen) would appear at the bottom of page 11 as a reminder of selecting answer E
  Condition 4 = forced-reminder-through-association condition: participants read that an image of an elephant (presented on screen) would appear at the bottom of page 11 as a reminder of selecting answer E.
  }
  \item{correct}{Did participants earn $0.60 bonus? (1 = yes; 0 = no)}
  \item{dup}{No available information}
  \item{fee_for_reminder}{How much was paid for a reminder? ($0.00 or $0.03)}
  \item{filter_.}{No available information}
  \item{final_problem}{Earned money for answering E on the last question: $0.00 (if E was not selected) or $0.60 (if E was selected)}
  \item{gender}{Gender; 0 = male; 1 = female}
  \item{id}{participants id}
  \item{plus}{Earned money at the beginning ( $0.06 for all participants)}
  \item{problem1}{First question for which participants earn a $0.03 bonus if they provide the correct answer}
  \item{problem2}{Second question for which participants earn a $0.03 bonus if they provide the correct answer}
  \item{problem3}{Third question for which participants earn a $0.03 bonus if they provide the correct answer}
  \item{problem4}{Fourth question for which participants earn a $0.03 bonus if they provide the correct answer}
  \item{problem5}{Fifth question for which participants earn a $0.03 bonus if they provide the correct answer}
  \item{Total_Amount_Earned}{Intention$final_problem minus Intention$fee_for reminder;
  They are 4 possibles outcomes: (1) $-0.03, if a reminder was paid and answer E was not selected on the last question;
  (2) $0.00, if no reminder was paid and answer E was not selected on the last question;
  (3) $0.57, if a reminder was paid and answer E was selected on the last question;
  (4) $0.60, is no reminder was paid and answer E was selected on the last question}
  \item{Total_Amount_Earned_if.forced.to.pay.for.cue}{equals Intention$Total_Amount_Earned in all but one condition: in condition 1 (free-reminder-through-association condition):
  Intention$Total_Amount_Earned_if.forced.to.pay.for.cue= Intention$Total_Amount_Earned - 0.03}
}}
\usage{
data(Intention)
}
\description{
Participants have to answer to many questions (in a 11-page-survey). For 5 questions (indicated by $$ at the beginning of the question), they are told that there is a correct answer and that they will earn $0.06 if they provide this correct answer.
At the beginning of the experiment, there are also told that they will earn a $0.60 bonus if they choose the answer E on the last question (whatever this is the correct answer or not).
}
\keyword{Intention}
\keyword{Reminder,}
