% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.pdb.R
\name{write.pdb}
\alias{write.pdb}
\title{PDB File Writer}
\usage{
write.pdb(x, file = "Rpdb.pdb")
}
\arguments{
\item{x}{an object, or a list of objects, of class \sQuote{pdb}.}

\item{file}{a single element character vector containing the name of the PDB file to be created.}
}
\value{
No return value, called for side effects.
}
\description{
Writes a Protein Data Bank (PDB) coordinate file from an object of class \sQuote{pdb}.
}
\details{
All data stored in the \sQuote{pdb} object are written to a PDB file. A list of objects of class \sQuote{pdb} can be provided to write multiple MODEL data into a single file. In this case, each \sQuote{pdb} object of the list must have the same \code{cryst1} and \code{conect} components.
\cr
To write only a subset of a \sQuote{pdb} object see function \code{\link{subset.pdb}}.
}
\examples{
# Read a PDB file included with the package
pdb <- read.pdb(system.file("examples/PCBM_ODCB.pdb", package="Rpdb"))

# Write the pdb object to file "Rpdb.pdb" in the current directory
write.pdb(pdb, file = "Rpdb.pdb")

# Cleanup
unlink("Rpdb.pdb")

}
\references{
PDB format is described at:
http://www.wwpdb.org/documentation/format33/v3.3.html
}
\seealso{
\code{\link{read.pdb}}, \code{\link{pdb}}, \code{\link{cryst1}}, \code{\link{atoms}}, \code{\link{conect}}, \code{\link{subset.pdb}}
}
\keyword{IO}
