% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_gibbs_samples_statistics.R
\name{RprobitB_gibbs_samples_statistics}
\alias{RprobitB_gibbs_samples_statistics}
\title{Compute parameter statistics.}
\usage{
RprobitB_gibbs_samples_statistics(gibbs_samples, FUN)
}
\arguments{
\item{gibbs_samples}{An object of class \code{RprobitB_gibbs_samples}.}

\item{FUN}{A (preferably named) list of functions that compute parameter statistics
from the Gibbs samples, i.e.
\itemize{
\item \code{mean} for the mean,
\item \code{sd} for the standard deviation,
\item \code{min} for the minimum,
\item \code{max} for the maximum,
\item \code{median} for the median,
\item \code{function(x) quantile(x, p)} for the \code{p}th quantile,
\item \code{R_hat} for the Gelman-Rubin statistic.
}}
}
\value{
An object of class \code{RprobitB_gibbs_samples_statistics}, which is a list
of statistics from \code{gibbs_samples} obtained by applying the elements of
\code{FUN}.
}
\description{
This function computes parameter statistics from Gibbs samples.
}
\keyword{s3}
