% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpopini.R
\name{pkpopini}
\alias{pkpopini}
\title{Compute initial population PK parameters}
\usage{
pkpopini(data = NULL, project = NULL, parameter = NULL,
  new.project = NULL, new.dir = NULL, par.ini = NULL)
}
\arguments{
\item{data}{a list with fields
\itemize{
  \item \code{dataFile}: path to a formatted data file
  \item \code{headerTypes}: a vector of strings
}}

\item{project}{a Monolix project}

\item{parameter}{a vector of strings (names of the PK parameters)}

\item{new.project}{name of the new Monolix project  (a default name is created if not provided)}

\item{new.dir}{name of the directory where the created files are stored 
(default is the current working directory) )}

\item{par.ini}{a vector of PK parameter values}
}
\value{
A list of results
}
\description{
Use the pooled PK data to derive population PK parameters for a "standard" PK model
(i.e. a model of the Monolix PK library). 
The structural model is automatically defined using the names of the PK parameters.
Allowed names are: 'Tlag', 'Mtt', 'Ktr', 'ka', 'Tk0', 'V', 'V1', 'V2', 'V3', 'Q', 'Q2', 'Q3', 
'Cl', 'k', 'k12', 'k21', 'k13', 'k31', 'Vm', 'Km'.
}
\details{
A Monolix project is then automatically created using these values as initial population parameters.

See http://rsmlx.webpopix.org/pkpopini/ for more details.
}
\examples{
\dontrun{
# Create in the working directory a Monolix project for a 1 cpt model with 
# lag time, 0 order absorption and linear elimination
warf.ini1 <- pkpopini(data=warfarin, param=c("Tlag", "Tk0", "V", "Cl")) 

# Create in directory 'warfarin' a Monolix project called 'warfPK2.mlxtran' 
# for a 2 cpt model with 1st order absorption and nonlinear elimination
warf.ini3 <- pkpopini(data=warfarin, param=c("ka", "V", "k12", "k21", "Vm", "Km"), 
                      new.dir="warfarin", new.project="warfPK2.mlxtran") 
}
}
