% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satBackup.R
\name{satBackup}
\alias{satBackup}
\title{Backup for Soundscape Saturation Index}
\usage{
satBackup(backupPath, od)
}
\arguments{
\item{backupPath}{path you set in your \code{backup} in the \code{soundSat()} function. Audiofiles already finished will be drawn from this path}

\item{od}{path or paths containing your original audiofiles}
}
\value{
A list containing five objects. The first and second objects (powthresh and bgnthresh) are the threshold values that yielded the most normal distribution of saturation values using the normality test set by the user. The third (normality) contains the statitics values of the normality test that yielded the most normal distribution. The fourth object (values) contains a data.frame with the the values of saturation for each bin of each recording and the size of the bin in seconds. The fifth contains a data.frame with errors that occurred with specific files during the function.
}
\description{
This function is a way to continue an unfinished process of the \code{soundSat()} or \code{soundMat()} functions through a backup file.
Arguments can't be inputted nor changed since the function will automatically load them from the original \code{soundSat()} run.
}
\examples{
\dontrun{
# It's impossible to create a functioning example since you would have to manually stop the process
# However, here is how this function is used:
## This example will load an entire day of audios to your computer, so beware.

### Downloading audiofiles from public Zenodo library
dir <- tempdir()
recName <- paste0("GAL24576_20250401_", sprintf("\%06d", seq(0, 230000, by = 10000)),".wav")
recDir <- paste(dir, recName, sep = "/")

for(rec in recName) {
  print(rec)
  url <- paste0("https://zenodo.org/records/17575795/files/", rec, "?download=1")
  download.file(url, destfile = paste(dir, rec, sep = "/"), mode = "wb")
}

sat <- soundSat(dir, backup = dir, wl = 256)

# Now pretend the process was interrupted (manually/your R crashed/your computer turned off)
# To recall the backup you simply:

satB <- satBackup(dir, dir)

unlink(recDir)
}
}
