% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgVertexNeighbors.r
\name{vcgVertexNeighbors}
\alias{vcgVertexNeighbors}
\title{Compute mesh adjacency list representation or the vertex neighborhoods of specific mesh vertices.}
\usage{
vcgVertexNeighbors(x, vi = NULL, numstep = 1L, include_self = FALSE)
}
\arguments{
\item{x}{tmesh3d instance from the \code{rgl} package}

\item{vi}{optional, vector of positive vertex indices for which to compute the neighborhoods. All vertices are used if left at the default value \code{NULL}.}

\item{numstep}{positive integer, the number of times to extend the neighborhood from the source vertices (the \code{k} for computing the \code{k}-ring neighborhood). Setting this to high values significantly increases the computational cost.}

\item{include_self}{logical, whether the returned neighborhood for a vertex \code{i} should include \code{i} itself.}
}
\value{
list of positive integer vectors, the neighborhoods.
}
\description{
Compute the \code{k}-ring vertex neighborhood for all query vertex indices \code{vi}. If only a mesh is passed (parameter \code{x}) and the other parameters are left at their default values, this compute the adjacency list representation of the mesh.
}
\examples{
data(humface)
adjacency_list <- vcgVertexNeighbors(humface)
v500_5ring = vcgVertexNeighbors(humface, vi=c(500), numstep = 5)

}
