# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

removableDrive <- function(driveRoot) {
    .Call(`_RxODE_removableDrive`, driveRoot)
}

#' Sample a covariance Matrix from the Posterior Inverse Wishart
#' distribution.
#'
#' Note this Inverse wishart rescaled to match the original scale of
#' the covariance matrix.
#'
#' If your covariance matrix is a 1x1 matrix, this uses an scaled
#' inverse chi-squared which is equivalent to the Inverse Wishart
#' distribution in the uni-directional case.
#'
#' @param nu Degrees of Freedom (Number of Observations) for 
#'        covariance matrix simulation.
#' 
#' @param omega Estimate of Covariance matrix.
#' 
#' @param n Number of Matrices to sample.  By default this is 1.
#' 
#' @param omegaIsChol is an indicator of if the omega matrix is in
#'   the Cholesky decomposition.
#' 
#' @param returnChol Return the Cholesky decomposition of the
#'   covariance matrix sample.
#'
#' @return a matrix (n=1) or a list of matrices  (n > 1)
#'
#' @author Matthew L.Fidler & Wenping Wang
#'
#' @examples
#' 
#' ## Sample a single covariance.
#' draw1 <- cvPost(3, matrix(c(1,.3,.3,1),2,2))
#'
#' ## Sample 3 covariances
#' set.seed(42)
#' draw3 <- cvPost(3, matrix(c(1,.3,.3,1),2,2), n=3)
#' 
#' ## Sample 3 covariances, but return the cholesky decomposition
#' set.seed(42)
#' draw3c <- cvPost(3, matrix(c(1,.3,.3,1),2,2), n=3, returnChol=TRUE)
#' @export
cvPost <- function(nu, omega, n = 1L, omegaIsChol = FALSE, returnChol = FALSE) {
    .Call(`_RxODE_cvPost`, nu, omega, n, omegaIsChol, returnChol)
}

#' Scaled Inverse Chi Squared distribution
#'
#' @param n Number of random samples
#' @param nu degrees of freedom of inverse chi square
#' @param scale  Scale of inverse chi squared distribution 
#'         (default is 1).
#' @return a vector of inverse chi squared deviates .
#' @examples
#' rinvchisq(3, 4, 1) ## Scale = 1, degrees of freedom = 4
#' rinvchisq(2, 4, 2) ## Scale = 2, degrees of freedom = 4
#' @export
rinvchisq <- function(n = 1L, nu = 1.0, scale = 1) {
    .Call(`_RxODE_rinvchisq`, n, nu, scale)
}

etUpdate <- function(obj, arg = NULL, value = NULL, exact = TRUE) {
    .Call(`_RxODE_etUpdate`, obj, arg, value, exact)
}

et_ <- function(input, et__) {
    .Call(`_RxODE_et_`, input, et__)
}

etSeq_ <- function(ets, handleSamples = 0L, waitType = 0L, defaultIi = 0, rbind = FALSE, uniqueId = 0L, reserveLen = 0L, needSort = TRUE, newUnits = as.character( c()), newShow = as.logical( c()), isCmtIntIn = FALSE) {
    .Call(`_RxODE_etSeq_`, ets, handleSamples, waitType, defaultIi, rbind, uniqueId, reserveLen, needSort, newUnits, newShow, isCmtIntIn)
}

etRep_ <- function(curEt, times, wait, ids, handleSamples, waitType, ii) {
    .Call(`_RxODE_etRep_`, curEt, times, wait, ids, handleSamples, waitType, ii)
}

#' Force using base order for RxODE radix sorting
#'
#' @param forceBase boolean indicating if RxODE should use R's
#'   \code{\link{order}} for radix sorting instead of
#'   \code{data.table}'s parallel radix sorting.
#'
#' @examples
#' \dontrun{
#' forderForceBase(TRUE) # Use base `order` for RxODE sorts
#' forderForceBase(FALSE) # Use base `data.table` for RxODE sorts
#' }
#'@export
forderForceBase <- function(forceBase = FALSE) {
    .Call(`_RxODE_forderForceBase`, forceBase)
}

#' Set Initial conditions to time zero instead of the first observed/dosed time
#'
#' @param ini0 When TRUE (default), set initial conditions to time
#'   zero. Otherwise the initial conditions are the first observed
#'   time.
#'
#' @export
rxSetIni0 <- function(ini0 = TRUE) {
    .Call(`_RxODE_rxSetIni0`, ini0)
}

#' Use Radix Sort when possible
#'
#' By default RxODE uses radix sort when possible.
#'
#' @param useRadix Use \code{order} with \code{method} = \code{radix}
#'   when appropriate.  Otherwise use \code{timsort}.
#'
#' @export
#' @author Matthew Fidler
rxUseRadixSort <- function(useRadix = TRUE) {
    .Call(`_RxODE_rxUseRadixSort`, useRadix)
}

#' Event translation for RxODE
#'
#' @param inData Data frame to translate
#' @param obj Model to translate data 
#' @param addCmt Add compartment to data frame (default code{FALSE}).
#' @param dropUnits Boolean to drop the units (default \code{FALSE}).
#' @param allTimeVar Treat all covariates as if they were time-varying
#' @param keepDosingOnly keep the individuals who only have dosing records and any
#'   trailing dosing records after the last observation.
#' @param combineDvid is a boolean indicating if RxODE will use \code{DVID} on observation
#'     records to change the \code{cmt} value; Useful for multiple-endpoint nlmixr models.  By default
#'     this is determined by \code{option("RxODE.combine.dvid")} and if the option has not been set,
#'     this is \code{TRUE}. This typically does not affect RxODE simulations.
#' @param keep This is a named vector of items you want to keep in the final RxODE dataset.
#'     For added RxODE event records (if seen), last observation carried forward will be used.
#' @return Object for solving in RxODE
#' @keywords internal
#' @export
etTrans <- function(inData, obj, addCmt = FALSE, dropUnits = FALSE, allTimeVar = FALSE, keepDosingOnly = FALSE, combineDvid = NULL, keep = character(0)) {
    .Call(`_RxODE_etTrans`, inData, obj, addCmt, dropUnits, allTimeVar, keepDosingOnly, combineDvid, keep)
}

#' Check the type of an object using Rcpp
#'
#' @param obj Object to check
#' @param cls Type of class.  Only s3 classes for lists/environments and primitive classes are checked.
#'    For matrix types they are distinguished as \code{numeric.matrix}, \code{integer.matrix},
#'    \code{logical.matrix}, and \code{character.matrix} as well as the traditional \code{matrix}
#'    class. Additionally checks for \code{event.data.frame} which is an \code{data.frame} object
#'    with \code{time},  \code{evid} and \code{amt}. (UPPER, lower or Title cases accepted)
#'
#' @return A boolean indicating if the object is a member of the class.
#' @keywords internal
#' @author Matthew L. Fidler
#' @export
rxIs <- function(obj, cls) {
    .Call(`_RxODE_rxIs`, obj, cls)
}

getRxFn <- function(name) {
    .Call(`_RxODE_getRxFn`, name)
}

dynLoad <- function(dll) {
    .Call(`_RxODE_dynLoad`, dll)
}

rxModelVars_ <- function(obj) {
    .Call(`_RxODE_rxModelVars_`, obj)
}

#' State variables
#'
#' This returns the model's compartments or states.
#'
#' @inheritParams rxModelVars
#'
#' @param state is a string indicating the state or compartment that
#'     you would like to lookup.
#'
#' @return If state is missing, return a character vector of all the states.
#'
#' If state is a string, return the compartment number of the named state.
#'
#' @seealso \code{\link{RxODE}}
#'
#' @author Matthew L.Fidler
#' @export
rxState <- function(obj = NULL, state = NULL) {
    .Call(`_RxODE_rxState`, obj, state)
}

rxParams_ <- function(obj) {
    .Call(`_RxODE_rxParams_`, obj)
}

#' Jacobian and parameter derivatives
#'
#' Return Jacobain and parameter derivatives
#'
#' @inheritParams rxModelVars
#'
#' @return A list of the jacobian parameters defined in this RxODE
#'     object.
#' @author Matthew L. Fidler
#' @export
rxDfdy <- function(obj) {
    .Call(`_RxODE_rxDfdy`, obj)
}

#' Left handed Variables
#'
#' This returns the model calculated variables
#'
#' @inheritParams rxModelVars
#'
#' @return a character vector listing the calculated parameters
#' @seealso \code{\link{RxODE}}
#'
#' @author Matthew L.Fidler
#' @export
rxLhs <- function(obj) {
    .Call(`_RxODE_rxLhs`, obj)
}

#' Initial Values and State values for a RxODE object
#'
#' Returns the initial values of the rxDll object
#'
#' @param obj rxDll, RxODE, or named vector representing default
#'     initial arguments
#'
#' @param vec If supplied, named vector for the model.
#'
#' @param req Required names, and the required order for the ODE solver
#'
#' @param defaultValue a number or NA representing the default value for
#'     parameters missing in \code{vec}, but required in \code{req}.
#'
#' @param noerror is a boolean specifying if an error should be thrown
#'     for missing parameter values when \code{default} = \code{NA}
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxInits <- function(obj, vec = NULL, req = NULL, defaultValue = 0, noerror = FALSE, noini = FALSE, rxLines = FALSE) {
    .Call(`_RxODE_rxInits`, obj, vec, req, defaultValue, noerror, noini, rxLines)
}

#' Setup the initial conditions.
#'
#' @param obj RxODE object
#' @param inits A numeric vector of initial conditions.
#' @author Matthew L. Fidler
#' @keywords internal
#' @export
rxSetupIni <- function(obj, inits = NULL) {
    .Call(`_RxODE_rxSetupIni`, obj, inits)
}

#' Setup the initial conditions.
#'
#' @param obj RxODE object
#' @param inits A numeric vector of initial conditions.
#' @param extraArgs A list of extra arguments to parse for initial conditions.
#' @author Matthew L. Fidler
#' @keywords internal
#' @export
rxSetupScale <- function(obj, scale = NULL, extraArgs = NULL) {
    .Call(`_RxODE_rxSetupScale`, obj, scale, extraArgs)
}

atolRtolFactor_ <- function(factor) {
    invisible(.Call(`_RxODE_atolRtolFactor_`, factor))
}

#' Simulate Parameters from a Theta/Omega specification
#'
#' @param params Named Vector of RxODE model parameters
#'
#' @param thetaMat Named theta matrix.
#' 
#' @param thetaLower Lower bounds for simulated population parameter variability (by default -Inf)
#'
#' @param thetaUpper Upper bounds for simulated population unexplained variability (by default Inf)
#'
#' @param thetaDf The degrees of freedom of a t-distribution for
#'     simulation.  By default this is \code{NULL} which is
#'     equivalent to \code{Inf} degrees, or to simulate from a normal
#'     distribution instead of a t-distribution.
#'
#' @param thetaIsChol Indicates if the \code{theta} supplied is a
#'     Cholesky decomposed matrix instead of the traditional
#'     symmetric matrix.
#'
#' @param nSub Number between subject variabilities (ETAs) simulated for every 
#'        realization of the parameters.
#'
#' @param omega Named omega matrix.
#'
#' @param omegaLower Lower bounds for simulated ETAs (by default -Inf)
#'
#' @param omegaUpper Upper bounds for simulated ETAs (by default Inf)
#'
#' @param omegaDf The degrees of freedom of a t-distribution for
#'     simulation.  By default this is \code{NULL} which is
#'     equivalent to \code{Inf} degrees, or to simulate from a normal
#'     distribution instead of a t-distribution.
#'
#' @param omegaIsChol Indicates if the \code{omega} supplied is a
#'     Cholesky decomposed matrix instead of the traditional
#'     symmetric matrix.
#'
#' @param nStud Number virtual studies to characterize uncertainty in estimated 
#'        parameters.
#'
#' @param nObs Number of observations to simulate (with \code{sigma} matrix)
#'
#' @param sigma Matrix for residual variation.  Adds a "NA" value for each of the 
#'     individual parameters, residuals are updated after solve is completed.
#'
#' @param sigmaLower Lower bounds for simulated unexplained variability (by default -Inf)
#'
#' @param sigmaUpper Upper bounds for simulated unexplained variability (by default Inf)
#'
#' @inheritParams rxSolve
#'
#' @param dfSub Degrees of freedom to sample the between subject variability matrix from the 
#'        inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.
#'
#' @param dfObs Degrees of freedom to sample the unexplained variability matrix from the 
#'        inverse Wishart distribution (scaled) or scaled inverse chi squared distribution. 
#'
#' @param simSubjects boolean indicated RxODE should simulate subjects in studies (\code{TRUE}, 
#'         default) or studies (\code{FALSE})
#'
#' @author Matthew L.Fidler
#'
#' @export
rxSimThetaOmega <- function(params = NULL, omega = NULL, omegaDf = NULL, omegaLower = as.numeric( c(R_NegInf)), omegaUpper = as.numeric( c(R_PosInf)), omegaIsChol = FALSE, nSub = 1L, thetaMat = NULL, thetaLower = as.numeric( c(R_NegInf)), thetaUpper = as.numeric( c(R_PosInf)), thetaDf = NULL, thetaIsChol = FALSE, nStud = 1L, sigma = NULL, sigmaLower = as.numeric( c(R_NegInf)), sigmaUpper = as.numeric( c(R_PosInf)), sigmaDf = NULL, sigmaIsChol = FALSE, nCoresRV = 1L, nObs = 1L, dfSub = 0, dfObs = 0, simSubjects = TRUE) {
    .Call(`_RxODE_rxSimThetaOmega`, params, omega, omegaDf, omegaLower, omegaUpper, omegaIsChol, nSub, thetaMat, thetaLower, thetaUpper, thetaDf, thetaIsChol, nStud, sigma, sigmaLower, sigmaUpper, sigmaDf, sigmaIsChol, nCoresRV, nObs, dfSub, dfObs, simSubjects)
}

#' Free the C solving/parsing information.
#'
#' Take the ODE C system and free it.
#'
#' @keywords internal
#' @export
rxSolveFree <- function() {
    .Call(`_RxODE_rxSolveFree`)
}

rxSolve_ <- function(obj, rxControl, specParams, extraArgs, params, events, inits, setupOnly) {
    .Call(`_RxODE_rxSolve_`, obj, rxControl, specParams, extraArgs, params, events, inits, setupOnly)
}

rxSolveGet <- function(obj, arg, exact = TRUE) {
    .Call(`_RxODE_rxSolveGet`, obj, arg, exact)
}

rxSolveUpdate <- function(obj, arg = NULL, value = NULL) {
    .Call(`_RxODE_rxSolveUpdate`, obj, arg, value)
}

rxRmModelLib_ <- function(str) {
    invisible(.Call(`_RxODE_rxRmModelLib_`, str))
}

#' Get RxODE model from object
#' @param obj RxODE family of objects
#' @export
rxGetRxODE <- function(obj) {
    .Call(`_RxODE_rxGetRxODE`, obj)
}

#' Checks if the RxODE object was built with the current build
#'
#' @inheritParams rxModelVars
#'
#' @return boolean indicating if this was built with current RxODE
#'
#' @export
rxIsCurrent <- function(obj) {
    .Call(`_RxODE_rxIsCurrent`, obj)
}

#' Assign pointer based on model variables
#' @param object RxODE family of objects
#' @export
rxAssignPtr <- function(object = NULL) {
    invisible(.Call(`_RxODE_rxAssignPtr`, object))
}

#' Get the number of cores in a system
#' @export
rxCores <- function() {
    .Call(`_RxODE_rxCores`)
}

#' Return the DLL associated with the RxODE object
#'
#' This will return the dynamic load library or shared object used to
#' run the C code for RxODE.
#'
#' @param obj A RxODE family of objects or a character string of the
#'     model specification or location of a file with a model
#'     specification.
#'
#' @return a path of the library
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxDll <- function(obj) {
    .Call(`_RxODE_rxDll`, obj)
}

#' Return the C file associated with the RxODE object
#'
#' This will return C code for generating the RxODE DLL.
#'
#' @param obj A RxODE family of objects or a character string of the
#'     model specification or location of a file with a model
#'     specification.
#'
#' @return a path of the library
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxC <- function(obj) {
    .Call(`_RxODE_rxC`, obj)
}

#' Determine if the DLL associated with the RxODE object is loaded
#'
#' @param obj A RxODE family of objects 
#'
#' @return Boolean returning if the RxODE library is loaded.
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxIsLoaded <- function(obj) {
    .Call(`_RxODE_rxIsLoaded`, obj)
}

#' Load RxODE object
#'
#' @param obj A RxODE family of objects 
#'
#' @return Boolean returning if the RxODE library is loaded.
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxDynLoad <- function(obj) {
    .Call(`_RxODE_rxDynLoad`, obj)
}

#' Lock/unlocking of RxODE dll file
#'
#' @param obj A RxODE family of objects
#' @export
rxLock <- function(obj) {
    .Call(`_RxODE_rxLock`, obj)
}

#' @rdname rxLock
#' @export
rxUnlock <- function(obj) {
    .Call(`_RxODE_rxUnlock`, obj)
}

#' Allow unloading of dlls
#'
#' @param allow boolean indicating if garbage collection will unload of RxODE dlls.
#'
#' @examples
#'
#' # Garbage collection will not unload un-used RxODE dlls
#' rxAllowUnload(FALSE);
#'
#' # Garbage collection will unload unused RxODE dlls
#' rxAllowUnload(TRUE);
#' @export
#' @author Matthew Fidler
rxAllowUnload <- function(allow) {
    .Call(`_RxODE_rxAllowUnload`, allow)
}

#' Unload all RxODE Dlls that are not locked for solving.
#' @return NULL
#' @export
rxUnloadAll_ <- function() {
    .Call(`_RxODE_rxUnloadAll_`)
}

#' Unload RxODE object
#'
#' @param obj A RxODE family of objects 
#'
#' @return Boolean returning if the RxODE library is loaded.
#'
#' @keywords internal
#' @author Matthew L.Fidler
#' @export
rxDynUnload <- function(obj) {
    .Call(`_RxODE_rxDynUnload`, obj)
}

#' Delete the DLL for the model
#'
#' This function deletes the DLL, but doesn't delete the model
#' information in the object.
#'
#' @param obj RxODE family of objects
#'
#' @return A boolean stating if the operation was successful.
#'
#' @author Matthew L.Fidler
#' @export
rxDelete <- function(obj) {
    .Call(`_RxODE_rxDelete`, obj)
}

setRstudio <- function(isRstudio = FALSE) {
    .Call(`_RxODE_setRstudio`, isRstudio)
}

setProgSupported <- function(isSupported = 1L) {
    .Call(`_RxODE_setProgSupported`, isSupported)
}

getProgSupported <- function() {
    .Call(`_RxODE_getProgSupported`)
}

rxUpdateTrans_ <- function(ret, prefix, libName) {
    .Call(`_RxODE_rxUpdateTrans_`, ret, prefix, libName)
}

dropUnitsRxSolve <- function(x) {
    .Call(`_RxODE_dropUnitsRxSolve`, x)
}

rxSetSilentErr <- function(silent) {
    .Call(`_RxODE_rxSetSilentErr`, silent)
}

#' Invert matrix using RcppArmadillo.  
#'
#' @param matrix matrix to be inverted.
#' @return inverse or pseudo inverse of matrix.
#' @export
rxInv <- function(matrix) {
    .Call(`_RxODE_rxInv`, matrix)
}

#' Get Omega^-1 and derivatives
#'
#' @param invObjOrMatrix Object for inverse-type calculations.  If this is a matrix,
#'     setup the object for inversion by \code{\link{rxSymInvCholCreate}} with the default arguments and return
#'     a reactive s3 object.  Otherwise, use the inversion object to calculate the requested derivative/inverse.
#' @param theta Thetas to be used for calculation.  If missing (\code{NULL}), a
#'     special s3 class is created and returned to access Omega^1
#'     objects as needed and cache them based on the theta that is
#'     used.
#' @param type The type of object.  Currently the following types are
#'     supported:
#' \itemize{
#' \item \code{cholOmegaInv} gives the
#'     Cholesky decomposition of the Omega Inverse matrix.
#' \item \code{omegaInv} gives the Omega Inverse matrix.
#' \item \code{d(omegaInv)} gives the d(Omega^-1) withe respect to the
#'     theta parameter specified in \code{thetaNumber}.
#' \item \code{d(D)} gives the d(diagonal(Omega^-1)) with respect to
#'     the theta parameter specified in the \code{thetaNumber}
#'     parameter
#' }
#' @param thetaNumber For types \code{d(omegaInv)} and \code{d(D)},
#'     the theta number that the derivative is taken against.  This
#'     must be positive from 1 to the number of thetas defining the
#'     Omega matrix.
#' @return Matrix based on parameters or environment with all the
#'     matrixes calculated in variables omega, omegaInv, dOmega,
#'     dOmegaInv.
#' @author Matthew L. Fidler
#' @export
rxSymInvChol <- function(invObjOrMatrix, theta = NULL, type = "cholOmegaInv", thetaNumber = 0L) {
    .Call(`_RxODE_rxSymInvChol`, invObjOrMatrix, theta, type, thetaNumber)
}

rxSymInvCholEnvCalculate <- function(obj, what, theta = NULL) {
    .Call(`_RxODE_rxSymInvCholEnvCalculate`, obj, what, theta)
}

#' Stack a solved object for things like ggplot
#'
#' @param Data is a RxODE object to be stacked.
#'
#' @param vars Variables to include in stacked data; By default this
#'   is all the variables when vars is NULL.
#'
#' @return Stacked data with \code{value} and \code{trt}, where value is the values
#'   and \code{trt} is the state and \code{lhs} variables.
#' 
#' @author Matthew Fidler
rxStack <- function(Data, vars = NULL) {
    .Call(`_RxODE_rxStack`, Data, vars)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_RxODE_RcppExport_registerCCallable', PACKAGE = 'RxODE')
})
