% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxJacobian.R
\name{rxSEinner}
\alias{rxSEinner}
\alias{rxSymPySetupPred}
\title{Setup Pred function based on RxODE object.}
\usage{
rxSEinner(
  obj,
  predfn,
  pkpars = NULL,
  errfn = NULL,
  init = NULL,
  grad = FALSE,
  sum.prod = FALSE,
  pred.minus.dv = TRUE,
  only.numeric = FALSE,
  optExpression = TRUE,
  interaction = TRUE,
  ...,
  promoteLinSens = TRUE,
  theta = FALSE,
  addProp = c("combined2", "combined1")
)

rxSymPySetupPred(
  obj,
  predfn,
  pkpars = NULL,
  errfn = NULL,
  init = NULL,
  grad = FALSE,
  sum.prod = FALSE,
  pred.minus.dv = TRUE,
  only.numeric = FALSE,
  optExpression = TRUE,
  interaction = TRUE,
  ...,
  promoteLinSens = TRUE,
  theta = FALSE,
  addProp = c("combined2", "combined1")
)
}
\arguments{
\item{obj}{RxODE object}

\item{predfn}{Prediction function}

\item{pkpars}{Pk Pars function}

\item{errfn}{Error function}

\item{init}{Initialization parameters for scaling.}

\item{grad}{Boolaen indicated if the the equations for the
gradient be calculated}

\item{sum.prod}{A boolean determining if RxODE should use more
numerically stable sums/products.}

\item{pred.minus.dv}{Boolean stating if the FOCEi objective
function is based on PRED-DV (like NONMEM).  Default TRUE.}

\item{only.numeric}{Instead of setting up the sensitivities for
the inner problem, modify the RxODE to use numeric
differentiation for the numeric inner problem only.}

\item{optExpression}{Optimize the model text for computer
evaluation.}

\item{interaction}{Boolean to determine if dR^2/deta is calculated
for FOCEi (not needed for FOCE)}

\item{promoteLinSens}{Promote solved linear compartment systems to
sensitivity-based solutions.}

\item{theta}{Calculate THETA derivatives instead of ETA
derivatives.  By default FALSE}

\item{addProp}{one of "combined1" and "combined2"; These are the
two forms of additive+proportional errors supported by
monolix/nonmem:

combined1: transform(y)=transform(f)+(a+b*f^c)*eps

combined2: transform(y)=transform(f)+(a^2+b^2*f^(2c))*eps}
}
\value{
RxODE object expanded with predfn and with calculated
sensitivities.
}
\description{
This is for the so-called inner problem.
}
\author{
Matthew L. Fidler
}
\keyword{internal}
