% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RbfInter.R
\name{trainCubicRBF}
\alias{trainCubicRBF}
\title{Fit cubic RBF interpolation to training data X for d>1.}
\usage{
trainCubicRBF(xp, U, ptail = TRUE, squares = FALSE, rho = 0,
  DEBUG2 = FALSE, width = NA)
}
\arguments{
\item{xp}{n points \eqn{x_i} of dimension d are arranged in (n x d) matrix \code{xp}}

\item{U}{vector of length n, containing samples \eqn{f(x_i)} of 
the scalar function \eqn{f} to be fitted \cr
- or - \cr
(n x m) matrix, where each column 1,...,m contains one vector of samples
\eqn{f_j(x_i)} for the m'th model, j=1,...,m}

\item{ptail}{[TRUE] flag, see description}

\item{squares}{[FALSE] flag, see description}

\item{rho}{[0.0] experimental: 0: interpolating, >0, approximating (spline-like) 
Gaussian RBFs}

\item{DEBUG2}{[FALSE] if TRUE, save \code{M} and \code{rhs} on return value}

\item{width}{[NA] non relevant for the parameter-free cubic RBF}
}
\value{
\code{rbf.model},  an object of class \code{RBFinter}, which is basically a list 
with elements:
     \item{coef}{  (n+d+1 x m) matrix holding in column m the coefficients for the m'th 
                   model:      \eqn{\lambda_1, ..., \lambda_n, c_0, c_1, ..., c_d}.  
                   In case \code{squares==TRUE} it is an (n+2d+1 x m) matrix holding  
                   additionally the coefficients \eqn{c_{d+1}, ..., c_{d+d}}.}                    
     \item{xp}{  matrix xp   }
     \item{d}{  size of the polynomial tail. If \code{length(d)==0} it means no polynomial tail will be used for the model. In case of ptail==T && squares==F d will be dimension+1 and in case of ptail==T && squares==T d will be 2*dimension+1 }
     \item{npts}{  number n of points \eqn{x_i} }
     \item{ptail}{TRUE or FALSE (see description)}
     \item{squares}{  TRUE or FALSE (see description)  }
     \item{type}{  "CUBIC"}
     \item{width}{NA, irrelevant for the parameter-free cubic RBF}
}
\description{
The model at a point \eqn{z=(z_1,...,z_d)} is fitted using n sample points \eqn{x_1, ..., x_n} 
\cr
   \deqn{ s(z) = \lambda_1*\Phi(||z-x_1||)+... +\lambda_n*\Phi(||z-x_n||)
                 + c_0 + c_1*z_1 + ... + c_d*z_d  }
\cr
where \eqn{\Phi(r)=r^3} denotes the cubic radial basis function. The coefficients \eqn{\lambda_1, 
..., \lambda_n, c_0, c_1, ..., c_d} are determined by this training procedure.\cr
This is for the default case \code{squares==FALSE}. In case \code{squares==TRUE} 
there are d additional pure square terms and the model is
\cr
   \deqn{ s_{sq}(z) = s(z) + c_{d+1}*z_1^2 + ... + c_{d+d}*z_d^2 } 
\cr
In case \code{ptail==FALSE} the polynomial tail (all coefficients \eqn{c_i}) is omitted completely.
}
\details{
The linear equation system is solved via SVD inversion. Near-zero elements 
in the diagonal matrix \eqn{D} are set to zero in \eqn{D^{-1}}. This is numerically stable 
for rank-deficient systems.
}
\seealso{
\code{\link{trainGaussRBF}}, \code{\link{trainMQRBF}} \code{\link{predict.RBFinter}}, \code{\link{interpRBF}}
}
\author{
Wolfgang Konen (\email{wolfgang.konen@th-koeln.de}), Samineh Bagheri (\email{samineh.bagheri@th-koeln.de})
}
