% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_posterior.R
\name{calc.post}
\alias{calc.post}
\title{Calculates SAVER posterior}
\usage{
calc.post(y, mu, sf, scale.sf)
}
\arguments{
\item{y}{A vector of observed gene counts.}

\item{mu}{A vector of prior means.}

\item{sf}{Vector of normalized size factors.}

\item{scale.sf}{Mean of the original size factors.}
}
\value{
A list with the following components
\item{\code{estimate}}{Recovered (normalized) expression}
\item{\code{se}}{Standard error of expression estimate}
}
\description{
Given prediction and prior variance, calculates the Gamma posterior
distribution parameters for a single gene.
}
\details{
Let \eqn{\alpha} be the shape parameter and \eqn{\beta} be the rate
parameter of the prior Gamma distribution. Then, the posterior Gamma
distribution will be
\deqn{Gamma(y + \alpha, sf + \beta),}
where y is the observed gene count and sf is the size factor.
}
