% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{edges}
\alias{edges}
\title{Class for edge data}
\usage{
edges(e, sym, loops, ...)
}
\arguments{
\item{e}{a matrix or array representing the raw edge-state data}

\item{sym}{is the network symmetric? (\code{e[ji] = e[ji]})}

\item{loops}{does the network contain self-loops? (edges from node i to i)}

\item{...}{additional arguments to append to edges internal list}
}
\value{
an edges object
}
\description{
A class to hold edge data
}
\examples{
## make an sbm model, sample data then plot and print:
model <- sbmmod(dma(2,5), param_beta(1,1,1,1), edges_bern())
s <- model$r(100)
e <- redges(s, model$edge)
plot(e)
plot(e, s)
print(e)
}
