% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_imputation.R
\name{simulation_imputation}
\alias{simulation_imputation}
\title{Simulate Longitudinal Data with Missing Values for Imputation}
\usage{
simulation_imputation(NNY = TRUE, NNX = TRUE, n_subject = 1000, seed = NULL)
}
\arguments{
\item{NNY}{A logical value. If \code{TRUE}, the outcome \code{Y} is generated using non-normal distributions
(Skew-t random effects, t-distribution residuals). If \code{FALSE}, it uses standard Normal distributions.
Default: \code{TRUE}.}

\item{NNX}{A logical value. If \code{TRUE}, the covariates \code{X_7} through \code{X_12} are generated using
non-normal distributions (Mixture models, Skew-t random effects). If \code{FALSE}, they use standard Normal distributions.
Default: \code{TRUE}.}

\item{n_subject}{An integer specifying the number of subjects. Default: \code{1000}.}

\item{seed}{An optional integer for setting the random seed to ensure reproducibility. Default: \code{NULL}.}
}
\value{
A list containing the following components:
\describe{
\item{data_E}{A data frame of the \strong{complete} data (ground truth) without any missing values.}
\item{data_M}{A data frame of the \strong{incomplete} data, containing \code{NA}s introduced by intermittent missingness and dropout.}
\item{data_O}{A duplicate of \code{data_E} used internally for generating missingness probabilities.}
\item{Z}{A matrix of random predictors (intercept and time slopes) used in generation.}
\item{pair}{A matrix summarizing the missing data pattern (generated via \code{mice::md.pattern}).}
}
}
\description{
Generates synthetic longitudinal data specifically designed to evaluate
missing data imputation methods. The function creates a complex dataset with:
\itemize{
\item \strong{Time-varying covariates} with autoregressive structures and random effects.
\item \strong{Non-linear relationships} and interactions between covariates.
\item \strong{Mixed data types} (continuous and binary/logical).
\item \strong{Non-normal Distributions} (optional) for both random effects and residuals (Skew-t, t-distribution).
\item \strong{Missing Data Mechanisms}:
\itemize{
\item \emph{Intermittent Missingness}: Generated via logistic models conditioned on outcomes and other covariates.
\item \emph{Loss to Follow-up (LTFU)}: Simulates subject dropout starting from time point 4 based on values at time point 3.
}
}
}
\details{
The simulation process creates 12 covariates (\code{X_1} to \code{X_12}):
\itemize{
\item \code{X_1} to \code{X_6}: Base covariates generated via multivariate normal distributions with autoregressive sigma. \code{X_4, X_5, X_6} are converted to binary.
\item \code{X_7} to \code{X_12}: Derived covariates dependent on the base set, involving non-linear transformations (squares, logs, interactions).
}

Missingness is introduced in two stages:
\enumerate{
\item \strong{Intermittent Missingness}: For variables \code{X_7} to \code{X_12}, missingness indicators are drawn from Bernoulli distributions where the probability depends on the outcome \code{Y} and other covariates.
\item \strong{Dropout}: A "Loss to Follow-up" indicator is generated based on data at time point 3. If a subject drops out, all values for time points 4 and 5 become \code{NA}.
}
}
\examples{
# Simulate data with non-normal errors and random effects
sim_data <- simulation_imputation(NNY = TRUE, NNX = TRUE, n_subject = 10, seed = 123)

# View missing data pattern
sim_data$pair
}
