% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_snapshot.R
\name{update_snapshot}
\alias{update_snapshot}
\title{Update a historical table}
\usage{
update_snapshot(
  .data,
  conn,
  db_table,
  timestamp,
  filters = NULL,
  message = NULL,
  tic = Sys.time(),
  log_path = getOption("SCDB.log_path"),
  log_table_id = getOption("SCDB.log_table_id"),
  enforce_chronological_order = TRUE
)
}
\arguments{
\item{.data}{A tbl object. Typically a lazy query to the DB (from get_table())}

\item{conn}{An object that inherits from DBIConnection (as generated by get_connection())'}

\item{db_table}{Either a dplyr connection to target table or a specification of 'schema.table'}

\item{timestamp}{A timestamp (POSIXct) with which to update from_ts/until_ts columns}

\item{filters}{A filter to subset data by.  if filters == NULL, no filtering occurs. Else, an inner_join is performed using all columns of the filter}

\item{message}{A message to add to the log-file (useful for supplying metadata to the log)}

\item{tic}{A timestamp when computation began. If not supplied, it will be created at call-time.
(Used to more accurately convey how long runtime of the update process has been)}

\item{log_path}{The path where logs are stored.
If NULL, no file logs are created.}

\item{log_table_id}{A \code{\link[DBI:Id]{DBI::Id()}} object or a character string readable by \link{id}, specifying the location of the log table.}

\item{enforce_chronological_order}{A logical that controls whether or not to check if timestamp of update is prior to timestamps in the DB}
}
\value{
No return value, called for side effects
}
\description{
Update a historical table
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

data <- dplyr::copy_to(conn, mtcars)

update_snapshot(data,
                conn = conn,
                db_table = "test.mtcars",
                timestamp = Sys.time())

close_connection(conn)
}
\seealso{
filter_keys
}
