% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_time.R
\name{slice_time}
\alias{slice_time}
\title{Slices a data object based on time / date}
\usage{
slice_time(.data, slice_ts, from_ts = "from_ts", until_ts = "until_ts")
}
\arguments{
\item{.data}{(\code{data.frame(1)}, \code{tibble(1)}, \code{data.table(1)}, or \code{tbl_dbi(1)})\cr
Data object.}

\item{slice_ts}{(\code{POSIXct(1)}, \code{Date(1)}, or \code{character(1)})\cr
The time / date to slice by.}

\item{from_ts, until_ts}{(\code{character(1)})\cr
The name of the columns in .data specifying valid from and valid until time.}
}
\value{
An object of same class as .data
}
\description{
Slices a data object based on time / date
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- get_connection()

  m <- mtcars |>
    dplyr::mutate(
      "from_ts" = dplyr::if_else(dplyr::row_number() > 10,
                                 as.Date("2020-01-01"),
                                 as.Date("2021-01-01")),
      "until_ts" = as.Date(NA))

  dplyr::copy_to(conn, m, name = "mtcars", temporary = FALSE)

  q <- dplyr::tbl(conn, id("mtcars", conn))

  nrow(slice_time(q, "2020-01-01")) # 10
  nrow(slice_time(q, "2021-01-01")) # nrow(mtcars)

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
