#' SCIntRuler: Integration of Single-Cell RNA-seq Datasets
#'
#' The SCIntRuler package addresses the challenges of integrating multiple single-cell RNA-seq (scRNA-seq) datasets. It provides tools to enhance analytical robustness by augmenting sample sizes and reducing batch discrepancies. Developed using the Seurat framework, SCIntRuler includes both existing and novel workflows for single-cell analysis.
#'
#' @section Why SCIntRuler? Integrating scRNA-seq datasets can be complex due to various factors such as batch effects and sample diversity. SCIntRuler provides a statistical metric to aid in crucial decisions regarding dataset integration, ensuring more robust and accurate analyses.
#' @author Yue Lyu
#'
#' @return This is the main page for SCIntRuler package.
#' @section Features:
#' \itemize{
#'   \item{Informed Decision Making: Helps researchers decide on the necessity
#'        of data integration and the most suitable method.}
#'   \item{Flexibility: Suitable for various scenarios, accommodating different
#'        levels of data heterogeneity.}
#'   \item{Robustness: Enhances analytical robustness in joint analyses of merged
#'        or integrated scRNA-seq datasets.}
#'   \item{User-Friendly: Streamlines decision-making processes, simplifying the
#'        complexities involved in scRNA-seq data integration.}
#' }
#'
#' @section Getting Started:Refer to the "Getting Started with SCIntRuler" article in the package vignettes for detailed user instructions.
#'
#' @name SCIntRuler-package
#' @aliases SCIntRuler
NULL
