% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindCell.R
\name{FindCell}
\alias{FindCell}
\title{Find cells indicating shared biological features across conditions}
\usage{
FindCell(seuratobj, seuratlist, fullcluster, distmat, firstn = 15)
}
\arguments{
\item{seuratobj}{The Seurat object that all samples/subjects were merged together.}

\item{seuratlist}{A list of Seurat objects, usually can be got by SplitObject().}

\item{fullcluster}{A list of clusters that generated by the function GetCluster().}

\item{distmat}{A list of distance vectors generated by the function FindNNDist().}

\item{firstn}{The number of nearest cells were detected that you want to include in the permutation test. Default to be 15.}
}
\value{
A list of two vectors: one is for which cluster of which sample will be highlighted and the second one is which cells will be selected.
}
\description{
Find cells indicating shared biological features across conditions
}
\examples{
\donttest{
data(sim_data_sce)
data(sim_result)
sim_data <- SCEtoSeurat(sim_data_sce)
seuratlist <- Seurat::SplitObject(sim_data, split.by = "Study")
FindCell(sim_data, seuratlist, sim_result[[1]], sim_result[[3]], 15)
}
}
