% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimized_HUM.R
\name{optimized_HUM}
\alias{optimized_HUM}
\alias{optimized_EHUM}
\alias{optimized_SHUM}
\alias{optimized_ULBA}
\title{Optimizing Different Estimators Of Hyper Volume Under Manifold}
\usage{
optimized_EHUM(beta_start, labels, x_mat, rho = 2, phi = 10^(-3),
  max_iter = 50000, s_init = 2, tol_fun = 10^(-6),
  tol_fun_2 = 10^(-6), minimize = FALSE, time = 6e+05,
  print = FALSE, lambda = 10^(-3), parallel = TRUE)

optimized_SHUM(beta_start, labels, x_mat, p = 0, rho = 2,
  phi = 10^(-3), max_iter = 50000, s_init = 2, tol_fun = 10^(-6),
  tol_fun_2 = 10^(-6), minimize = FALSE, time = 6e+05,
  print = FALSE, lambda = 10^(-3), parallel = TRUE)

optimized_ULBA(beta_start, labels, x_mat, rho = 2, phi = 10^(-3),
  max_iter = 50000, s_init = 2, tol_fun = 10^(-6),
  tol_fun_2 = 10^(-6), minimize = FALSE, time = 6e+05,
  print = FALSE, lambda = 10^(-3), parallel = TRUE)
}
\arguments{
\item{beta_start}{The initial guess for optimum \eqn{\beta} by user}

\item{labels}{Sample Sizes vector of that has number of elements in each category. It works like the labels of data matrix.}

\item{x_mat}{The Data Matrix}

\item{rho}{Step Decay Rate with default value 2}

\item{phi}{Lower Bound Of Global Step Size. Default value is \eqn{10^{-6}}}

\item{max_iter}{Max Number Of Iterations In each Run. Default Value is 50,000.}

\item{s_init}{Initial Global Step Size. Default Value is 2.}

\item{tol_fun}{Termination Tolerance on the function value. Default Value is \eqn{10^{-6}}}

\item{tol_fun_2}{Termination Tolerance on the difference of solutions in two consecutive runs. Default Value is \eqn{10^{-6}}}

\item{minimize}{Binary Command to set SCOptim on minimization or maximization. FALSE is for minimization which is set default.}

\item{time}{Time Allotted for execution of SCOptim}

\item{print}{Binary Command to print optimized value of objective function after each iteration. FALSE is set fault}

\item{lambda}{Sparsity Threshold. Default value is \eqn{10^{-3}}}

\item{parallel}{Binary Command to ask SCOptim to perform parallel computing. Default is set at TRUE.}

\item{p}{This parameter exists for the case of optimized_SHUM only.p decides whether to use \eqn{s_n(x)} or \eqn{\phi_n(x)}. p = 1 stands for \eqn{\phi_n(x)} and p = 0 stands for \eqn{s_n(x)}}
}
\value{
Optimum Values Of HUM Estimates
}
\description{
As we know `SCOptim` is efficient in estimating maximizing Hyper Volume Under Manifolds Estimators,
we made some pre-functions that optimizes specific Problems of EHUM,SHUM and ULBA.
}
\details{
Optimization of EHUM, SHUM and ULBA using SCOptim.
}
\examples{

\donttest{
  optimized_SHUM(rep(1, 12), colnames(AL), AL, parallel = FALSE)
# This run will take about 10 mins on average based on computational capacity of the system
# Optimum value of HUM estimate noticed for this case : 0.8440681
}

optimized_EHUM(rep(1, 12), colnames(AL), AL, parallel = FALSE)
# Optimum value of HUM estimate noticed for this case : 0.8403805

optimized_ULBA(rep(1, 12), colnames(AL), AL, parallel = FALSE)
# Optimum value of HUM estimate noticed for this case : 0.9201903

}
