% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_functions.R
\name{euclidean_distance}
\alias{euclidean_distance}
\title{(Pairwise) Euclidean distances between two sets of samples}
\usage{
euclidean_distance(x, y)
}
\arguments{
\item{x}{A numeric matrix or data frame with \emph{M} rows (one per sample) and \emph{P} columns (one per feature).}

\item{y}{\code{NULL} (default) or a numeric matrix or data frame with \emph{N} rows (one per sample) and \emph{P} columns (one per feature).}
}
\value{
An \emph{M}-by-\emph{M} (if \code{y} is \code{NULL}) or an \emph{M}-by-\emph{N} (otherwise) matrix containing the Euclidean distances between the given sets of samples.
}
\description{
\code{euclidean_distance} calculates the (pairwise) Euclidean distances between one or two sets of samples.
}
\examples{
## generate two matrices with 50 and 100 samples
x <- matrix(rnorm(50*10, mean=0, sd=1), ncol=10)
y <- matrix(rnorm(100*10, mean=1, sd=2), ncol=10)
dist <- euclidean_distance(x, y)

## compare with the standard dist function
dist2 <- as.matrix(dist(rbind(x, y)))[1:50, 51:150]
plot(dist, dist2)
}
