% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.placebos.R
\name{generate.placebos}
\alias{generate.placebos}
\alias{generate_placebos}
\title{Function to generate placebo synthetic controls}
\usage{
generate.placebos(
  dataprep.out,
  synth.out,
  Sigf.ipop = 5,
  strategy = "sequential"
)

generate_placebos(
  dataprep.out,
  synth.out,
  Sigf.ipop = 5,
  strategy = "sequential"
)
}
\arguments{
\item{dataprep.out}{A data.prep object produced by the \code{dataprep} command}

\item{synth.out}{A synth.out object produced by the \code{synth} command}

\item{Sigf.ipop}{The Precision setting for the ipop optimization routine. 
Default of 5.}

\item{strategy}{The processing method you wish to use 
"sequential", "multicore" or "multisession". Use "multicore" or "multisession" to parallelize operations
 and reduce computing time. Default is \code{sequential}. Since SCtools >= 0.3.2 "multiprocess" is deprecated.}
}
\value{
\describe{
   \item{df }{Data frame with outcome data for each control unit and their 
   respective synthetic control and for the original treated and its control}
   \item{mspe.placs }{Mean squared prediction error for the pretreatment 
   period for each placebo}
   \item{t0}{First time unit in \code{time.optimize.ssr}}
   \item{t1}{First time unit after the highest value in \code{time.optimize.ssr}}
   \item{tr}{Unit number of the treated unit}
   \item{names.and.numbers}{Dataframe with two columns showing all unit 
   numbers and names from control units}
   \item{n}{Number of control units}
   \item{treated.name}{Unit name of the treated unit}
   \item{loss.v}{Pretreatment MSPE of the treated unit's synthetic control}
}
}
\description{
Constructs a synthetic control unit for each unit in the 
   donor pool of an implementation of the synthetic control method for a 
   single treated unit. Used for placebo tests (see \link{plot_placebos}, 
   \link{mspe.test}, \link{mspe.plot}) to assess the strength and 
   significance of a causal inference based on the synthetic control method. 
   On placebo tests, see Abadie and Gardeazabal (2003), and Abadie, Diamond, 
   and Hainmueller (2010, 2011, 2014).
}
\examples{
\dontshow{## Example with toy data from Synth
library(Synth)
# Load the simulated data
data(synth.data)

# Execute dataprep to produce the necessary matrices for synth
dataprep.out<-
  dataprep(
    foo = synth.data,
    predictors = c("X1"),
    predictors.op = "mean",
    dependent = "Y",
    unit.variable = "unit.num",
    time.variable = "year",
    special.predictors = list(
      list("Y", 1991, "mean")
    ),
    treatment.identifier = 7,
    controls.identifier = c(29, 2, 17),
    time.predictors.prior = c(1984:1989),
    time.optimize.ssr = c(1984:1990),
    unit.names.variable = "name",
    time.plot = 1984:1996
)

# run the synth command to create the synthetic control
synth.out <- synth(dataprep.out, Sigf.ipop=1)

tdf <- generate.placebos(dataprep.out,synth.out, Sigf.ipop = 1)
}
\dontrun{## Example with toy data from Synth
library(Synth)
# Load the simulated data
data(synth.data)

# Execute dataprep to produce the necessary matrices for synth
dataprep.out<-
  dataprep(
    foo = synth.data,
    predictors = c("X1"),
    predictors.op = "mean",
    dependent = "Y",
    unit.variable = "unit.num",
    time.variable = "year",
    special.predictors = list(
      list("Y", 1991, "mean")
    ),
    treatment.identifier = 7,
    controls.identifier = c(29, 2, 13, 17),
    time.predictors.prior = c(1984:1989),
    time.optimize.ssr = c(1984:1990),
    unit.names.variable = "name",
    time.plot = 1984:1996
)

# run the synth command to create the synthetic control
synth.out <- synth(dataprep.out, Sigf.ipop=2)

## run the generate.placebos command to reassign treatment status
## to each unit listed as control, one at a time, and generate their
## synthetic versions. Sigf.ipop = 2 for faster computing time. 
## Increase to the default of 5 for better estimates. 
tdf <- generate.placebos(dataprep.out,synth.out, Sigf.ipop = 2)
}
}
