% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxentTh.R
\name{maxentTh}
\alias{maxentTh}
\title{MaxEnt Thresholds}
\usage{
maxentTh(model)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} object trained using the "Maxent" method.}
}
\value{
data.frame with the thresholds.
}
\description{
Returns the value of the thresholds generated by the MaxEnt software.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Train a Maxent model
# The next line checks if Maxent is correctly configured but you don't need
# to run it in your script
if (dismo::maxent(silent = TRUE)) {
model <- train(method = "Maxent", data = data, fc = "l")
maxentTh(model)
}
}
}
\seealso{
\link{maxentVarImp}.
}
\author{
Sergio Vignali
}
