## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----include=FALSE-------------------------------------------------------
set.seed(328342)

## ----import, echo=TRUE---------------------------------------------------
library(SDraw)

## ----sampling------------------------------------------------------------
data("WA")
n <- 25
J <- c(3,2)
S <- sdraw(WA, n, "HIP", J = J)

## ------------------------------------------------------------------------
S

## ----plot----------------------------------------------------------------
hip.plot.lattice(WA, J = J, sample = S)

## ------------------------------------------------------------------------
n <- 70
J <- c(3,2)
S <- sdraw(WA, n, "HIP", J = J)
hip.plot.lattice(WA, J = J, sample = S)

